<?php

/**
 * This file is part of Dev5 Framework for OpenCart
 *
 * @author    Dev5™ <developer@dev5.com.br>
 * @copyright Dev5™ 2025. Todos os direitos reservados.
 * @license   Distribuição/reprodução não autorizada estará sujeita às penas das leis 9609/98 e 9610/98
 * @link      https://dev5.com.br
 * @phpcs:disable
 */

namespace Dev5\OpenCart;

spl_autoload_register(static function ($class) {
    static $fixed = false;

    # FIX 4X
    if (!$fixed && preg_match('/^OpenCart\\\(Admin|Catalog)\\\Controller\\\Startup\\\Event/i', $class)) {
        $fixed = true;

        # AUTOLOAD DEV5/OPENCART CLASS
        if (file_exists($oc = realpath(__DIR__ . '/opencart.php'))) {
            require_once $oc;
        }

        \Dev5\OpenCart\normalize();
    }

    if (preg_match('/^Opencart\\\(Admin|Catalog)\\\(Controller|Model)\\\Extension\\\Dev5\\\(.*)/i', $class, $matches)) {
        $file = constant('DIR_EXTENSION') . "dev5/$matches[1]/$matches[2]/$matches[3].php";

        if (file_exists($oc = realpath(__DIR__ . '/opencart.php'))) {
            require_once $oc;
        }

        if (file_exists($file)) {
            require_once $file;
        }
    }

    return class_exists($class, false);
}, true, true);

if (!function_exists("\\Dev5\\OpenCart\\glob_recursive")) {
    function glob_recursive($path)
    {
        $result = [];

        foreach (glob($path, GLOB_BRACE) as $i) {
            if (is_dir($i)) {
                $result = array_merge($result, [$i], \Dev5\OpenCart\glob_recursive("$i/{,.}*[!.]"));
            } else {
                $result[] = $i;
            }
        }

        return $result;
    }
}

if (!function_exists("\\Dev5\\OpenCart\\unlink_recursive")) {
    function unlink_recursive($path)
    {
        if (!is_dir($path) && is_file($path)) {
            return unlink($path);
        }

        if (!is_dir($path)) {
            return true;
        }

        if ($path[strlen($path) - 1] !== DIRECTORY_SEPARATOR) {
            $path .= DIRECTORY_SEPARATOR;
        }

        foreach (glob($path . '{,.}[!.,!..]*', GLOB_BRACE | GLOB_MARK) as $i) {
            if (is_dir($i)) {
                \Dev5\OpenCart\unlink_recursive($i);
            }

            if (is_file($i)) {
                @unlink($i);
            }
        }

        return rmdir($path);
    }
}

if (!function_exists('\\Dev5\\OpenCart\\move')) {
    function move($from, $to)
    {
        if ($from === $to) {
            return true;
        } elseif (is_dir($from)) {
            return is_dir($to) || mkdir($to, 0755, true);
        } elseif (file_exists($from)) {
            file_exists($to) && @unlink($to);
            is_dir(dirname($to)) || mkdir(dirname($to), 0755, true);
            return rename($from, $to);
        }
        return false;
    }
}

if (!function_exists('\\Dev5\\OpenCart\\path_combine')) {
    function path_combine(...$combine)
    {
        return preg_replace('/\/+/', '/', str_replace("\\", "/", implode("/", $combine)));
    }
}

if (!function_exists('\\Dev5\\OpenCart\\normalize')) {
    function normalize()
    {
        try {
            # FIX 4X
            $files = [
                constant('DIR_SYSTEM') . "engine/action.php",
                constant('DIR_SYSTEM') . "engine/loader.php"
            ];

            foreach ($files as $file) {
                if (!file_exists($file)) {
                    continue;
                }

                $content = file_get_contents($file);
                $normalized = preg_replace(
                    '/(if\s+?\()(?:\s+)?(\$object\s+instanceof\s+\\\Opencart\\\System\\\Engine\\\(?:Controller|Model))/i',
                    '$1\$object instanceof \Dev5\IOpenCart || $2',
                    $content
                );

                if ($content !== $normalized) {
                    @file_put_contents($file, $normalized);
                }
            }

            foreach (glob_recursive(path_combine(__DIR__, '/dat/*.4x')) as $extension_dat) {
                $db = \Dev5\OpenCart\OpenCart::registry('db');
                $p = DB_PREFIX;
                $extension_id = basename($extension_dat, '.4x');

                # GET CURRENT INSTALLED PACKAGE ID
                $extension_install_id = @$db->query("SELECT MAX(`extension_install_id`) AS `id` FROM `{$p}extension_path` WHERE `path` LIKE '%d5$extension_id.php'")->row['id'] ?: null;

                if ($extension_install_id) {
                    $extension_install_id = (int)$extension_install_id;

                    # GET CURRENT INFO PACKAGE
                    $extension_info = $db->query("SELECT * FROM `{$p}extension_install` WHERE `extension_install_id` = '$extension_install_id'")->row;

                    if (!empty($extension_info['code'])) {
                        $extension_code = "dev5_$extension_id";

                        # FIX PACKAGE FILE NAME
                        \Dev5\OpenCart\move(
                            path_combine(constant('DIR_STORAGE'), "/marketplace/$extension_info[code].ocmod.zip"),
                            path_combine(constant('DIR_STORAGE'), "/marketplace/$extension_code.ocmod.zip")
                        );

                        # FIX EXTENSION FILES NAME
                        $old_path = path_combine(constant('DIR_EXTENSION'), "/$extension_info[code]/");
                        $new_path = path_combine(constant('DIR_EXTENSION'), "/dev5/");
                        if ($old_path === $new_path) {
                            continue;
                        }

                        foreach (\Dev5\OpenCart\glob_recursive($old_path) as $i) {
                            if (path_combine($i) === path_combine($old_path, "/install.json")) {
                                continue;
                            }

                            \Dev5\OpenCart\move($i, path_combine($new_path, substr($i, strlen($old_path))));
                        }
                        \Dev5\OpenCart\unlink_recursive($old_path);

                        # FIX EXTENSION FILES DB NAME AND FIX UNINSTALL DEV5 LIBRARY
                        $db->query("DELETE FROM `{$p}extension_path` WHERE `extension_install_id` <> '$extension_install_id' AND `path` LIKE '{$db->escape("%d5$extension_id.php")}'");
                        $db->query("DELETE FROM `{$p}extension_path` WHERE `extension_install_id` = '$extension_install_id' AND (`path` LIKE '%vendor/dev5%' OR `path` NOT LIKE '%.php')");
                        $db->query("UPDATE `{$p}extension_path` SET `path` = REPLACE(`path`, '{$db->escape("$extension_info[code]/")}', 'dev5/') WHERE `extension_install_id` = '$extension_install_id' AND `path` LIKE '{$db->escape("$extension_info[code]/%")}'");
                        $db->query("INSERT INTO `{$p}extension_path` SET `extension_install_id` = '$extension_install_id', `path` = '{$db->escape("system/storage/vendor/dev5/opencart/dat/$extension_id")}'");
                        $db->query("INSERT INTO `{$p}extension_path` SET `extension_install_id` = '$extension_install_id', `path` = '{$db->escape("system/storage/vendor/dev5/opencart/dat/$extension_id.4x")}'");
                        $db->query("INSERT INTO `{$p}extension_path` SET `extension_install_id` = '$extension_install_id', `path` = '{$db->escape("system/storage/vendor/dev5/opencart/dat/$extension_id.fst")}'");
                        $db->query("INSERT INTO `{$p}extension_path` SET `extension_install_id` = '$extension_install_id', `path` = '{$db->escape("system/storage/vendor/dev5/opencart/dat/$extension_id.lcs")}'");
                        $db->query("INSERT INTO `{$p}extension_path` SET `extension_install_id` = '$extension_install_id', `path` = '{$db->escape("system/storage/vendor/dev5/opencart/dat/$extension_id.upd")}'");

                        # FIX PACKAGE DB NAME
                        $db->query("DELETE FROM `{$p}extension_install` WHERE `code` = '{$db->escape("$extension_code")}' AND `extension_install_id` <> '$extension_install_id'");
                        $db->query("UPDATE `{$p}extension_install` SET `code` = '{$db->escape("$extension_code")}' WHERE `extension_install_id` = '$extension_install_id'");
                        if ($db->query("SHOW COLUMNS FROM `{$p}extension_install` LIKE 'package_name'")->num_rows > 0) {
                            $db->query("UPDATE `{$p}extension_install` SET `package_name` = '{$db->escape("$extension_code")}' WHERE `extension_install_id`='$extension_install_id'");
                        }
                    }

                    # REMOVE SPL FILE
                    \Dev5\OpenCart\unlink_recursive($extension_dat);
                }
            }
        } catch (\Exception $e) {
        } catch (\Throwable $e) {
        }
    }
}
