<div :class="'form-group row mt-3 mb-3' + (invalidate_access_token() ? ' has-error' : '')">
    <label :class="'col-sm-2 control-label col-form-label' + (invalidate_access_token() ? ' text-danger' : '')">
        <?= $_['field_oauth2'] ?>
    </label>
    <div class="col-sm-10">
        <button type="button" @click="oauth2" :disabled="invalidate_button_oauth2()" :class="'btn btn-lg btn-primary' + (invalidate_button_oauth2() ? ' disabled' : '')">
            <?= $_['button_oauth2'] ?>
        </button>
        <div style="display:inline-flex;width:auto;margin-left:15px">
            <span class="alert alert-success" v-if="access_token" style="position:relative;top:1px">
                <i class="fa fa-check-circle"></i> <b><?= $_['text_success_token'] ?> <?= @$bling_info['nome'] ?> (<?= @$bling_info['email'] ?>)</b>
            </span>
            <span class="alert alert-danger" v-if="error_token" style="position:relative;top:1px">
                <i class="fa fa-exclamation-circle"></i> <b>[[ error_token ]]</b>
            </span>
        </div>
    </div>
</div>
<script type="module">
    $('head').append(`
        <style>
            #tab-general .alert{margin:0}
            div:has(>.checkbox [name*="d5bling_order_status"]),
            div:has(>.checkbox [name*="d5bling_payment_method"]){display:flex;align-items:center;width:fit-content;padding:0 0 0 15px}
            div:has(>.checkbox [name*="d5bling_order_status"]) label,
            div:has(>.checkbox [name*="d5bling_order_status"]) span,
            div:has(>.checkbox [name*="d5bling_payment_method"]) label,
            div:has(>.checkbox [name*="d5bling_payment_method"]) span{white-space:nowrap;display:flex;align-items:center;gap:7px;padding:0}
            div:has(>.checkbox [name*="d5bling_order_status"]) label *,
            div:has(>.checkbox [name*="d5bling_payment_method"]) label *{margin:0!important}
            div:has(>[name*="d5bling_payment_method"][name*="days"]){width:150px}
            #tab-ei fieldset>legend{margin:1rem 0}
            #tab-ei fieldset>div{margin-top:1rem}
            #tab-ei fieldset>div+div{border-top:1px solid #ededed;padding-top:1rem}
            #tab-ei .dev5-input-group{align-items:center}
            #tab-ei .dev5-input-group>div:first-child{width:calc(16.66666667% + 30px);min-width:135px;margin-right:15px;display:flex;justify-content:flex-end}
            #tab-ei .well{width:100%;margin:0}

            [for*="tutorial"]:before{display:none!important}
            .alert-info a[data-toggle="collapse"]{width:100%;display:block}
            .alert-info a[data-toggle="collapse"] .fa-chevron-down{transition:all ease .3s;position:relative;float:right}
            .alert-info a[data-toggle="collapse"][aria-expanded="true"] .fa-chevron-down{transform:rotate(-180deg);top:1px}
            .alert-info code{padding:2px 4px;font-size:90%;color:#c7254e;background-color:#f9f2f4;border-radius:3px}
            .alert-info p:has(+ul),.alert-info ul:last-child,.alert-info .card{margin-bottom:0;line-height:1.3rem}
            .alert-info li{line-height:1.3rem}

            .form-group:has(>[for="input-canais"]) .form-control:empty:before,
            .form-group:has(>[for="input-canais"]) .form-control:not(:has(.checkbox:not([style*='none']))):before{display:inline-block;font:normal normal normal 14px / 1 FontAwesome;font-size:inherit;text-rendering:auto;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;content:"\\f071";margin-right:5px}
            .form-group:has(>[for="input-canais"]) .form-control:empty:after,
            .form-group:has(>[for="input-canais"]) .form-control:not(:has(.checkbox:not([style*='none']))):after{display:inline-block;content:'<?= $_['field_canais_empty'] ?>';line-height:25px}
        </style>
    `);
    $('#dev5-form-button-cancel').before(`
      <div class="dropdown" style="display:inline">
        <button type="button" data-toggle="dropdown" data-bs-toggle="dropdown" dev5-tooltip="<?= $_['button_actions'] ?>"
                :class="'btn btn-default btn-light dropdown-toggle' + (invalidate_access_token() ? ' disabled' : '')"
                :disabled="invalidate_access_token()">
          <i class="fa fa-ellipsis-v fa-fw"></i>
        </button>
        <ul class="dropdown-menu dropdown-menu-right">
          <li class="dropdown-header"><i class="fa fa-upload fa-fw"></i> <?= $_['text_export'] ?></li>
          <li><a class="dropdown-item" href="javascript:ei('export_categories')">&emsp;• <?= $_['button_export_categories'] ?>&emsp;<i class="fa fa-external-link pull-right float-end"></i></a></li>
          <li><a class="dropdown-item" href="javascript:ei('export_products')">&emsp;• <?= $_['button_export_products'] ?>&emsp;<i class="fa fa-external-link pull-right float-end"></i></a></li>
          <li><a class="dropdown-item" href="javascript:ei('export_orders')">&emsp;• <?= $_['button_export_orders'] ?>&emsp;<i class="fa fa-external-link pull-right float-end"></i></a></li>
          <li class="divider dropdown-divider"></li>
          <li class="dropdown-header"><i class="fa fa-download fa-fw"></i> <?= $_['text_import'] ?></li>
          <li><a class="dropdown-item" href="javascript:ei('import_categories')">&emsp;• <?= $_['button_import_categories'] ?>&emsp;<i class="fa fa-external-link pull-right float-end"></i></a></li>
          <li><a class="dropdown-item" href="javascript:ei('import_products')">&emsp;• <?= $_['button_import_products'] ?>&emsp;<i class="fa fa-external-link pull-right float-end"></i></a></li>
          <li><a class="dropdown-item" href="javascript:ei('import_orders')">&emsp;• <?= $_['button_import_orders'] ?>&emsp;<i class="fa fa-external-link pull-right float-end"></i></a></li>
          <li class="divider dropdown-divider"></li>
          <li class="dropdown-header"><i class="fa fa-refresh fa-fw"></i> <?= @$_['text_clear'] ?></li>
          <li><a class="dropdown-item" href="<?= @$href_clear_cache ?>">&emsp;• <?= $_['button_clear_cache'] ?></a></li>
        </ul>
      </div>&nbsp;
    `.trim());
    $.dev5.ready(() => {
        $(['#tab-order.is-invalid', '#tab-product.is-invalid', '#tab-ei.is-invalid', '#tab-queue.is-invalid'].join(',')).each(function () {
            $(this).html(`
                <h2 class="text-center has-error" style="padding:7rem 1rem">
                    <i class="fa fa-fw fa-lock"></i> <?= @$_['text_need_auth'] ?>
                </h2>
                <div style="display:none!important">
                    ${$(this).html()}
                </div>
            `)
        });
        $(['#section-callback_section.is-invalid', '#section-cron_section.is-invalid', '#section-others_section.is-invalid'].join(',')).append(`
           <h2 class="text-center has-error" style="padding:3rem 1rem">
                <i class="fa fa-fw fa-lock"></i> <?= @$_['text_need_auth'] ?>
           </h2>
        `).find('>div').hide();
    });

    let current_access_token = '';
    $.dev5.form.method('oauth2', function () {
        current_access_token = $.dev5.form.values(true).access_token;
        $.dev5.form.values().error_token = false;
        $.dev5.form.values().access_token = '';
        $.dev5.form.update();

        $.dev5.rwin.open('dev5-bling-oauth2', {
            url: `<?= @$href_oauth2 ?>&client_id=${$.dev5.form.values().client_id}&client_secret=${$.dev5.form.values().client_secret}`,
            success(json) {
                console.log('RWin Bling OAuth2 Success', json);
                location.reload();
            },
            error(json) {
                console.log('RWin Bling OAuth2 Error', json);
                json?.code === 204
                    ? ($.dev5.form.values().access_token = current_access_token)
                    : ($.dev5.form.values().error_token = json?.message);
                $.dev5.form.update();
            }
        });
    });

    $.dev5.form.method('invalidate_button_oauth2', function () {
        return this.invalidate_client_id() || this.invalidate_client_secret()
    });

    $.dev5.form.method('no_main_channel_id', function (channel_id) {
        return parseInt($.dev5.form.values().channel_id) !== parseInt(channel_id);
    })

    $.dev5.form.method('no_main_seller_id', function (channel_id) {
        return parseInt($.dev5.form.values().vendedor) !== parseInt(channel_id);
    })

    $.dev5.ready(() => {
        $("#dt-queue-table").on("draw.dt", () => setTimeout(() => $.dev5.form.datatable("queue").redraw(), 7_500));
        $.dev5.form.datatable("queue").redraw();
    })
</script>
<script type="text/javascript">
    function ei(type) {
        $.dev5.rwin.open('dev5-bling-ei', `<?= @$href_ei_event ?>&type=${type}&event=getting-form`)
    }
</script>