<?php

/**
 * This file is part of Dev5 Integração ERP Bling API V3 for OpenCart
 *
 * @author    Dev5™ <developer@dev5.com.br>
 * @copyright Dev5™ 2025. Todos os direitos reservados.
 * @license   Distribuição/reprodução não autorizada estará sujeita às penas das leis 9609/98 e 9610/98
 * @link      https://dev5.com.br/integracao-erp-bling-api-v3
 * @version   4.0.6
 * @phpcs:disable
 */

$_['text_extension'] = 'Extensões';
$_['text_success'] = 'Integração ERP Bling API V3 modificada com sucesso';

$_['text_success_token'] = 'Autenticado com sucesso com: ';
$_['text_need_auth'] = 'Você precisa autenticar-se para acessar esta área';

$_['text_success_clear_cache'] = 'Cache limpo com sucesso';

$_['text_type'] = 'Tipo';

$_['text_autocomplete'] = "(autocomplete)";
$_['text_autocomplete_none'] = '--- Não informar ---';
$_['text_autocomplete_empty'] = 'Nenhum resultado encontrado';
$_['text_autocomplete_loading'] = 'Aguarde...';
$_['text_autocomplete_error'] = 'Não foi possível carregar os resultados, recarregue a página e tente novamente';

$_['text_well_remove'] = 'Remover item';

$_['text_customer_opt_none'] = '--- Não informar ---';
$_['text_customer_opt_special'] = 'Campos especiais';
$_['text_customer_opt_default'] = 'Campos padrões';
$_['text_customer_opt_custom'] = 'Campos personalizados';
$_['text_customer_opt_address_payment'] = 'Endereço para fatura';
$_['text_customer_opt_address_shipping'] = 'Endereço para entrega';
$_['text_customer_opt_customer'] = 'Nome Completo';
$_['text_customer_opt_customer_id'] = 'Id do Cliente';
$_['text_customer_opt_zone_code'] = 'UF';

$_['field_invalid'] = 'Campo obrigatório!';

$_['button_actions'] = "Ações manuais";

$_['text_export'] = "Exportar";
$_['button_export_categories'] = "Exportar categorias";
$_['button_export_products'] = "Exportar produtos";
$_['button_export_orders'] = "Exportar pedidos";

$_['text_import'] = "Importar";
$_['button_import_categories'] = "Importar categorias";
$_['button_import_products'] = "Importar produtos";
$_['button_import_orders'] = "Importar pedidos";

$_['text_clear'] = "Limpar";
$_['button_clear_cache'] = <<<HTML
Limpar cache <small class="text-muted">(Atualizar as informações do Bling nesta página)</small>
HTML;

// --- Tab General

$_['tab_general'] = "Geral";

$_['field_status'] = "Situação";

$_['field_auth_section_legend'] = "Autenticação";

$_['field_auth_tutorial'] = '';
$_['field_auth_tutorial_text'] = <<<HTML
<div class="alert alert-info"><b>
    <a data-toggle="collapse" data-bs-toggle="collapse" href="#step-auth" aria-expanded="false">
        <i class="fa fa-book"></i> Tutorial: Como criar credenciais <i class="fa fa-chevron-down"></i>
    </a>
    <div class="collapse" id="step-auth" style="margin-top:15px">
        <div class="panel panel-body card card-body">
            <p>Acesse: <a href="https://www.bling.com.br/cadastro.aplicativos.php#/form" target="_blank"><u>Cadastro de aplicativos - Bling <i class="fa fa-external-link fa-fw" style="font-size:10px"></i></u></a></p>
            <p>Em <u>Tipo do aplicativo</u></p>
            <ul>
                <li>Campo Tipo do aplicativo: <code>API</code></li>
                <li>Campo Selecione o uso do aplicativo: <code>Privado</code></li>
                <li>Clique no botão <code>Próximo</code></li>
            </ul>
            <p>Em <u>Dados básicos</u></p>
            <ul>
                <li>Campo Logo: Opcional</li>
                <li>Campo Nome: <code>Dev5 Integração</code></li>
                <li>Campo Categoria: <code>Plataforma de e-commerce</code></li>
                <li>Campo Descrição: <code>Dev5 Integração Bling API V3 para OpenCart</code></li>
                <li>Campo Link de redirecionamento: <code>{{ oauth2 }}</code></li>
                <li>Campo Lista de escopos:</li>
                <ul>
                    <li><code>Campos Customizados</code></li>
                    <li><code>Campos Customizados > Clientes e Fornecedores</code></li>
                    <li><code>Campos Customizados > Produtos</code></li>
                    <li><code>Categoria de Produtos</code></li>
                    <li><code>Categoria de Produtos > Gerenciar Categorias de Produtos</code></li>
                    <li><code>Categoria de Produtos > Exclusão de Categorias de Produtos</code></li>
                    <li><code>Clientes e Fornecedores</code></li>
                    <li><code>Clientes e Fornecedores > Gerenciar Contatos</code></li>
                    <li><code>Controle de Estoque</code></li>
                    <li><code>Controle de Estoque > Controle avançado de estoque: Inserção de Estoque</code></li>
                    <li><code>Depósitos de Estoque</code></li>
                    <li><code>Gerenciador de transições</code></li>
                    <li><code>Integrações Logísticas</code></li>
                    <li><code>Integrações e Lojas Virtuais</code></li>
                    <li><code>Pedidos de Venda</code></li>
                    <li><code>Pedidos de Venda > Gerenciar Pedidos de Venda</code></li>
                    <li><code>Pedidos de Venda > Exclusão de Pedidos de Venda</code></li>
                    <li><code>Pedidos de Venda > Gerenciar situações dos Pedidos de Venda</code></li>
                    <li><code>Pedidos de Venda > Lançar estoque em Pedidos de Venda</code></li>
                    <li><code>Produtos</code></li>
                    <li><code>Produtos > Gerenciar Produtos</code></li>
                    <li><code>Produtos > Exclusão de Produtos</code></li>
                    <li><code>Produtos > Salvar imagens dos Produtos</code></li>
                    <li><code>Produtos > Salvar variações de Produtos</code></li>
                    <li><code>Visualizar os dados básicos da empresa</code></li>
                </ul>
                <li>Campo Informações para contato > Nome do desenvolvedor: <code>Dev5</code></li>
                <li>Campo Informações para contato > Email: <code>developer@dev5.com.br</code></li>
                <li>Campo Informações para contato > Celular: <code>74 98117-4219</code></li>
                <li>Clique no botão <code>Salvar dados básicos</code></li>
            </ul>
            <p>Em <u>Informações do app</u></p>
            <ul>
                <li>Copie o valor do campo <code>Client ID</code> para o campo correspondente no OpenCart</li>
                <li>Copie o valor do campo <code>Client Secret</code> para o campo correspondente no OpenCart</li>
                <li>No OpenCart, clique no botão <code>Autenticar</code></li>
            </ul>
            <p>Em <u>Popup Autorizar aplicativo</u></p>
            <ul>
                <li>Clique no botão <code>Autorizar</code></li>
            </ul>
        </div>
    </div>
</b></div>
HTML;

$_['field_client_id'] = "Client ID";
$_['field_client_id_help'] = "Campo fornecido após criar a aplicação no Bling";
$_['field_client_id_invalid'] = "$_[field_client_id] é um campo obrigatório";

$_['field_client_secret'] = "Client Secret";
$_['field_client_secret_help'] = "Campo fornecido após criar a aplicação no Bling";
$_['field_client_secret_invalid'] = "$_[field_client_secret] é um campo obrigatório";

$_['field_oauth2'] = "";
$_['button_oauth2'] = "Autenticar";

$_['field_callback_section_legend'] = "Canal de Venda / Callback";

$_['field_callback_tutorial'] = '';
$_['field_callback_tutorial_text'] = <<<HTML
<div class="alert alert-info"><b>
    <a data-toggle="collapse" data-bs-toggle="collapse" href="#callback_tutorial" aria-expanded="false">
        <i class="fa fa-book"></i> Tutorial: Criar um canal de venda com callback <i class="fa fa-chevron-down"></i>
    </a>
    <div class="collapse" id="callback_tutorial" style="margin-top:15px">
        <div class="panel panel-body card card-body">
            <p>Acesse: <a href="https://www.bling.com.br/configuracoes.integracoes.lojas.virtuais.php#add/ApiDev5/312" target="_blank"><u>Configurações de Multiloja - Bling <i class="fa fa-external-link fa-fw" style="font-size:10px"></i></u></a></p>
            <p>Em <u>Autenticação</u></p>
            <ul>
                <li>Campo Nome do canal de venda: <code>Dev5 Callback</code></li>
            </ul>
            <p>Em <u>Callbacks</u></p>
            <ul>
                <li>Campo Tipo de retorno no callback: <code>JSON</code></li>
                <li>Ative os callbacks e insira a URL: <code>{{ callback }}</code></li>
                <ul>
                    <li>Callback de estoque</li>
                    <li>Callback de pedidos de venda</li>
                </ul>
            </ul>           
            <p>Em <u>Filial</u></p>
            <ul>
                <li>Selecione todas as unidades que serão sincronizadas com o OpenCart</li> 
                <li>Clique no botão <code>Salvar</code></li>
            </ul>           

            <p>De volta ao OpenCart</p>
            <ul>
                <li>Recarregue esta página e selecione o canal de venda criado</li>
                <li>Caso não esteja aparecendo, faça o passo a passo do tutorial "<a href="javascript:" onclick="$('html,body').animate({scrollTop: $('[href=\'#cache_tutorial\']').offset().top}, 1000);$('[href=\'#cache_tutorial\']').click()">Limpar cache da API</a>"</li>
            </ul>
        </div>
    </div>
</b></div>
HTML;

$_['field_channel_id'] = "Canal de Venda";
$_['field_channel_id_help'] = "Campo fornecido após criar o canal de venda no Bling";
$_['field_channel_id_invalid'] = "$_[field_channel_id] é um campo obrigatório";

$_['field_cron_section_legend'] = "Cronjob";

$_['field_cron_tutorial'] = '';
$_['field_cron_tutorial_text'] = <<<HTML
<div class="alert alert-info"><b>
    <a data-toggle="collapse" data-bs-toggle="collapse" href="#cron_tutorial" aria-expanded="false">
        <i class="fa fa-book"></i> Tutorial: Configurando a Tarefa Cron (Cronjob) <i class="fa fa-chevron-down"></i>
    </a>
    <div class="collapse" id="cron_tutorial" style="margin-top:15px">
        <div class="panel panel-body card card-body">
            <p>Acesse o painel da sua hospedagem</p>
            <p>Configure uma nova Tarefa Cron (Cronjob)</p>
            <ul>
                <li>Campo Minuto: <code>*</code></li>
                <li>Campo Hora: <code>*</code></li>
                <li>Campo Dia: <code>*</code></li>
                <li>Campo Mês: <code>*</code></li>
                <li>Campo Dia da semana: <code>*</code></li>
                <li>Campo Comando:</li>
                <ul>
                    <li>via curl: <code>curl -s "{{ cron }}" > /dev/null</code></li>
                    <li>via wget: <code>wget -q -O - "{{ cron }}" > /dev/null</code></li>
                </ul>
            </ul>
        </div>
    </div>
</b></div>
HTML;

$_['field_command'] = "Comando";
$_['field_command_help'] = "Comando utilizado para processar a fila de sincronização dos dados entre o OpenCart e o Bling";

$_['field_others_section_legend'] = "Outros";

$_['field_image_url_tutorial'] = '';
$_['field_image_url_tutorial_text'] = <<<HTML
<div class="alert alert-info"><b>
    <a data-toggle="collapse" data-bs-toggle="collapse" href="#image_url_tutorial" aria-expanded="false">
        <i class="fa fa-book"></i> Tutorial: Enviar imagens como URL <i class="fa fa-chevron-down"></i>
    </a>
    <div class="collapse" id="image_url_tutorial" style="margin-top:15px">
        <div class="panel panel-body card card-body">
            <p>Enviar imagens como URL irá melhorar consideravelmente a comunicação entre o OpenCart e o Bling. para isso:</p>
            <p>Acesse: <a href="https://www.bling.com.br/preferencias.php#cadastro/cadastros-produto?param=URL%20de%20Imagens%20Externas" target="_blank"><u>Preferências - Bling <i class="fa fa-external-link fa-fw" style="font-size:10px"></i></u></a></p>
            <p>Em <u>Configurações de produtos</u></p>
            <ul>
                <li>Campo Na importação/Exportação de produtos para Lojas Virtuais e Marketplaces, considerar: <code>URL de Imagens Externas</code></li>
                <li>Clique no botão <code>Salvar</code></li>
            </ul>
        </div>
    </div>
</b></div>
HTML;

$_['field_cache_tutorial'] = '';
$_['field_cache_tutorial_text'] = <<<HTML
<div class="alert alert-info"><b>
    <a data-toggle="collapse" data-bs-toggle="collapse" href="#cache_tutorial" aria-expanded="false">
        <i class="fa fa-book"></i> Tutorial: Limpar cache da API <i class="fa fa-chevron-down"></i>
    </a>
    <div class="collapse" id="cache_tutorial" style="margin-top:15px">
        <div class="panel panel-body card card-body">
            <p>O cache da API é utilizado para armazenar informações que são utilizadas nesta página para agilizar o carregamento. Caso você tenha feito alguma alteração no Bling e não esteja refletindo nesta página, siga os passos abaixo:</p> 
            <p></p>
            <ul>
                <li>Utilize o botão na parte superior direita desta página: [ <i class="fa fa-ellipsis-v"></i> ] > Limpar cache</li>
            </ul>
        </div>
    </div>
</b></div>
HTML;

$_['field_debug'] = "<i class='text-danger'>Debug</i>";
$_['field_debug_help'] = "<p>Ao ativar este campo irá gerar um log de todas as operações armazenado em:</p><p><code style='display:block'>" . DIR_LOGS . "d5bling.log</code></p>Não é recomendado deixar ativo por muito tempo, pois o log pode crescer rapidamente e ocupar muito espaço em disco.";

// --- Tab Product

$_['tab_product'] = "Produtos";

$_['field_code_mode'] = "Código";
$_['field_code_mode_help'] = <<<HTML
<p class='text-secondary'>O código do produto é sincronizado entre OpenCart e o Bling. (É utilizado para verificar a existência de um produto na exportação/importação):</p>
<table class='table table-sm table-condensed table-bordered' style='margin-bottom:0;width:fit-content'>
    <tr>
        <th class='text-center text-secondary'>Tipo de Código</th>
        <th class='text-center text-secondary'>Produto simples</th>
        <th class='text-center text-secondary'>Produto com 1 opção</th>
        <th class='text-center text-secondary'>Produto com 2+ opções</th>
    </tr>
    <tr>
        <td class='text-center text-secondary'>ID</td>
        <td class='text-center text-secondary'><i>123</td>
        <td class='text-center text-secondary'><i>123-456</i></td>
        <td class='text-center text-secondary'><i>123-456-789</i></td>
    </tr>
    <tr>
        <td class='text-center text-secondary'>SKU</td>
        <td class='text-center text-secondary'><i>PRO123</i></td>
        <td class='text-center text-secondary'><i>PRO123-OPT456</i></td>
        <td class='text-center text-secondary'><i>PRO123-OPT456-OPT789</i></td>
    </tr>
</table>
HTML;
$_['field_code_mode_invalid'] = "$_[field_code_mode] é um campo obrigatório";
$_['field_sku_opt_product_id'] = "ID (recomendado)";
$_['field_sku_opt_sku'] = "SKU";
$_['field_sku_opt_comb'] = "SKU Combinada";

$_['field_view_mode'] = "Modo de Visualização";
$_['field_view_mode_help'] = "Modo de exibição dos campos exclusivos do Bling";
$_['field_view_mode_opt_tab'] = "Exibir em uma aba exclusiva para o Bling";
$_['field_view_mode_opt_inline'] = "Exibir junto aos do Opencart";

$_['field_language_id'] = "Linguagem";
$_['field_language_id_help'] = "Linguagem que será utilizada para integração com o Bling";
$_['field_language_id_invalid'] = "$_[field_language_id] é um campo obrigatório";

$_['field_weight_class_id'] = "Peso(Kg)";
$_['field_weight_class_id_help'] = "Peso padrão que será utilizado para integração com o Bling";
$_['field_weight_class_id_invalid'] = "$_[field_weight_class_id] é um campo obrigatório";

$_['field_length_class_id'] = "Medida(cm)";
$_['field_length_class_id_help'] = "Medida padrão que será utilizada para integração com o Bling";
$_['field_length_class_id_invalid'] = "$_[field_length_class_id] é um campo obrigatório";

$_['field_currency_code'] = "Moeda";
$_['field_currency_code_help'] = "Moeda padrão que será utilizada para integração com o Bling";
$_['field_currency_code_invalid'] = "$_[field_currency_code] é um campo obrigatório";

$_['field_deposito'] = "Depósito padrão";
$_['field_deposito_help'] = "Depósito padrão que será utilizado para integração com o Bling";
$_['field_deposito_invalid'] = "$_[field_deposito] é um campo obrigatório";

$_['field_canais'] = <<<HTML
<w style="position:relative">
    Canais de venda
    <a href="https://www.bling.com.br/central.extensoes.php#/pages/minhas-instalacoes" target="_blank" style="position:absolute;right:0;bottom:-15px;font-size:9px;white-space:nowrap">
        Gerenciar <i class="fa fa-external-link" style="font-size:8px"></i>
    </a>
</w>
HTML;
$_['field_canais_help'] = "Selecione os canais de venda extras que serão sincronizas com o OpenCart";
$_['field_canais_empty'] = "Nenhuma canal de venda extra cadastrado";

// --- Tab Order

$_['tab_order'] = "Pedido";

$_['field_contato_legend'] = "Dados do Cliente";

$_['field_contato_codigo'] = "Id do Cliente";
$_['field_contato_codigo_help'] = "Campo correspondente ao id do cliente.";
$_['field_contato_codigo_invalid'] = "$_[field_contato_codigo] é um campo obrigatório";

$_['field_contato_nome'] = "Nome";
$_['field_contato_nome_help'] = "Campo correspondente ao Nome completo do cliente.";
$_['field_contato_nome_invalid'] = "$_[field_contato_nome] é um campo obrigatório";

$_['field_contato_fantasia'] = "Nome fantasia";
$_['field_contato_fantasia_help'] = "Campo correspondente ao Nome fantasia do cliente.";
$_['field_contato_fantasia_invalid'] = "$_[field_contato_fantasia] é um campo obrigatório";

$_['field_contato_email'] = "Email";
$_['field_contato_email_help'] = "Campo correspondente ao email do cliente.";
$_['field_contato_email_invalid'] = "$_[field_contato_email] é um campo obrigatório";

$_['field_contato_telefone'] = "Telefone";
$_['field_contato_telefone_help'] = "Campo correspondente ao telefone do cliente.";
$_['field_contato_telefone_invalid'] = "$_[field_contato_telefone] é um campo obrigatório";

$_['field_contato_celular'] = "Celular";
$_['field_contato_celular_help'] = "Campo correspondente ao celular do cliente.";

$_['field_contato_cpf'] = "CPF";
$_['field_contato_cpf_help'] = "Campo correspondente ao CPF do cliente.";
$_['field_contato_cpf_invalid'] = "$_[field_contato_cpf] é um campo obrigatório";

$_['field_contato_cnpj'] = "CNPJ";
$_['field_contato_cnpj_help'] = "Campo correspondente ao CNPJ do cliente.";
$_['field_contato_cnpj_invalid'] = "$_[field_contato_cnpj] é um campo obrigatório";

$_['field_contato_rg'] = "RG";
$_['field_contato_rg_help'] = "Campo correspondente ao RG do cliente.";
$_['field_contato_rg_invalid'] = "$_[field_contato_rg] é um campo obrigatório";

$_['field_contato_orgaoEmissor'] = "Órgão emissor do RG";
$_['field_contato_orgaoEmissor_help'] = "Campo correspondente ao Órgão emissor do RG do cliente.";

$_['field_contato_ie'] = "Inscrição Estadual";
$_['field_contato_ie_help'] = "Campo correspondente a Inscrição Estadual do cliente.";

$_['field_contato_indicadorIe'] = "Tipo de Contribuinte";
$_['field_contato_indicadorIe_help'] = <<<HTML
<p>Campo correspondente ao Tipo de Contribuinte do cliente. Deve seguir as opções:</p>
<table class='table table-sm table-condensed table-bordered' style='margin-bottom:0;width:fit-content'>
    <tr>
        <th class='text-center text-secondary'>Valor</th>
        <th class='text-center text-secondary'>Descrição</th>
    </tr>
    <tr>
        <td class='text-center text-secondary'>1</td>
        <td class='text-center text-secondary'>Contribuinte ICMS</td>
    </tr>
    <tr>
        <td class='text-center text-secondary'>2</td>
        <td class='text-center text-secondary'>Contribuinte isento de Inscrição no Cadastro de Contribuintes</td>
    </tr>
    <tr>
        <td class='text-center text-secondary'>9</td>
        <td class='text-center text-secondary'>Não contribuinte, que pode ou não possuir Inscrição Estadual no Cadastro de Contribuintes</td>
    </tr>
</table>
HTML;

$_['field_contato_defaultIndicadorIe'] = "Tipo de Contribuinte padrão";
$_['field_contato_defaultIndicadorIe_help'] = "Valor padrão para o campo Tipo de Contribuinte do cliente.";
$_['field_contato_defaultIndicadorIe_opt_none'] = "--- Não informar ---";
$_['field_contato_defaultIndicadorIe_opt_1'] = "1 - Contribuinte ICMS";
$_['field_contato_defaultIndicadorIe_opt_2'] = "2 - Contribuinte isento de Inscrição no Cadastro de Contribuintes";
$_['field_contato_defaultIndicadorIe_opt_9'] = "9 - Não contribuinte, que pode ou não possuir Inscrição Estadual no Cadastro de Contribuintes";

$_['field_contato_im'] = "Inscrição Municipal";
$_['field_contato_im_help'] = "Campo correspondente a Inscrição Municipal do cliente.";

$_['field_contato_dataNascimento'] = "Data de Nascimento";
$_['field_contato_dataNascimento_help'] = 'Campo correspondente a Data de Nascimento do cliente. Deve seguir o formato: YYYY-MM-DD';

$_['field_contato_sexo'] = "Sexo";
$_['field_contato_sexo_help'] = <<<HTML
<p>Campo correspondente ao Sexo do cliente. Deve seguir as opções:</p>
<table class='table table-sm table-condensed table-bordered' style='margin-bottom:0;width:fit-content'>
    <tr>
        <th class='text-center text-secondary'>Valor</th>
        <th class='text-center text-secondary'>Descrição</th>
    </tr>
    <tr>
        <td class='text-center text-secondary'>M</td>
        <td class='text-center text-secondary'>Masculino</td>
    </tr>
    <tr>
        <td class='text-center text-secondary'>F</td>
        <td class='text-center text-secondary'>Feminino</td>
    </tr>
</table>
HTML;

$_['field_contato_naturalidade'] = "Naturalidade";
$_['field_contato_naturalidade_help'] = "Campo correspondente a Naturalidade do cliente.";

$_['field_contato_campos_customizados_legend'] = <<<HTML
<w style="position:relative">
    Campos Customizados
    <a href="https://www.bling.com.br/b/campos.customizados.php" target="_blank" style="font-size:9px;white-space:nowrap">
        <b>Gerenciar <i class="fa fa-external-link" style="font-size:8px"></i></b>
    </a>
</w>
HTML;
$_['field_contato_campos_customizados_none'] = "<i class=\"fa fa-exclamation-triangle\"></i> Nenhum campo customizado encontrado";

$_['field_contato_endereco_geral_legend'] = "Endereço para entrega";

$_['field_contato_endereco_geral_nome'] = "Nome";
$_['field_contato_endereco_geral_nome_help'] = "Campo correspondente ao Nome do cliente.";
$_['field_contato_endereco_geral_nome_invalid'] = "$_[field_contato_endereco_geral_nome] é um campo obrigatório";

$_['field_contato_endereco_geral_cep'] = "CEP";
$_['field_contato_endereco_geral_cep_help'] = "Campo correspondente ao CEP do cliente.";
$_['field_contato_endereco_geral_cep_invalid'] = "$_[field_contato_endereco_geral_cep] é um campo obrigatório";

$_['field_contato_endereco_geral_endereco'] = "Endereço";
$_['field_contato_endereco_geral_endereco_help'] = "Campo correspondente ao endereço do cliente.";
$_['field_contato_endereco_geral_endereco_invalid'] = "$_[field_contato_endereco_geral_endereco] é um campo obrigatório";

$_['field_contato_endereco_geral_numero'] = "Número";
$_['field_contato_endereco_geral_numero_help'] = "Campo correspondente ao Número do cliente.";
$_['field_contato_endereco_geral_numero_invalid'] = "$_[field_contato_endereco_geral_numero] é um campo obrigatório";

$_['field_contato_endereco_geral_bairro'] = "Bairro";
$_['field_contato_endereco_geral_bairro_help'] = "Campo correspondente ao Bairro do cliente.";
$_['field_contato_endereco_geral_bairro_invalid'] = "$_[field_contato_endereco_geral_bairro] é um campo obrigatório";

$_['field_contato_endereco_geral_municipio'] = "Cidade";
$_['field_contato_endereco_geral_municipio_help'] = "Campo correspondente ao Cidade do cliente.";
$_['field_contato_endereco_geral_municipio_invalid'] = "$_[field_contato_endereco_geral_municipio] é um campo obrigatório";

$_['field_contato_endereco_geral_uf'] = "UF";
$_['field_contato_endereco_geral_uf_help'] = "Campo correspondente ao Estado do cliente.";
$_['field_contato_endereco_geral_uf_invalid'] = "$_[field_contato_endereco_geral_uf] é um campo obrigatório";

$_['field_contato_endereco_geral_complemento'] = "Complemento";
$_['field_contato_endereco_geral_complemento_help'] = "Campo correspondente ao Complemento do cliente.";

$_['field_contato_endereco_cobranca_legend'] = "Endereço para fatura";

$_['field_contato_endereco_cobranca_nome'] = "Nome";
$_['field_contato_endereco_cobranca_nome_help'] = "Campo correspondente ao Nome do cliente.";
$_['field_contato_endereco_cobranca_nome_invalid'] = "$_[field_contato_endereco_geral_nome] é um campo obrigatório";

$_['field_contato_endereco_cobranca_cep'] = "CEP";
$_['field_contato_endereco_cobranca_cep_help'] = "Campo correspondente ao CEP do cliente.";
$_['field_contato_endereco_cobranca_cep_invalid'] = "$_[field_contato_endereco_cobranca_cep] é um campo obrigatório";

$_['field_contato_endereco_cobranca_endereco'] = "Endereço";
$_['field_contato_endereco_cobranca_endereco_help'] = "Campo correspondente ao endereço do cliente.";
$_['field_contato_endereco_cobranca_endereco_invalid'] = "$_[field_contato_endereco_cobranca_endereco] é um campo obrigatório";

$_['field_contato_endereco_cobranca_numero'] = "Número";
$_['field_contato_endereco_cobranca_numero_help'] = "Campo correspondente ao Número do cliente.";
$_['field_contato_endereco_cobranca_numero_invalid'] = "$_[field_contato_endereco_cobranca_numero] é um campo obrigatório";

$_['field_contato_endereco_cobranca_bairro'] = "Bairro";
$_['field_contato_endereco_cobranca_bairro_help'] = "Campo correspondente ao Bairro do cliente.";
$_['field_contato_endereco_cobranca_bairro_invalid'] = "$_[field_contato_endereco_cobranca_bairro] é um campo obrigatório";

$_['field_contato_endereco_cobranca_municipio'] = "Cidade";
$_['field_contato_endereco_cobranca_municipio_help'] = "Campo correspondente ao Município do cliente.";
$_['field_contato_endereco_cobranca_municipio_invalid'] = "$_[field_contato_endereco_cobranca_municipio] é um campo obrigatório";

$_['field_contato_endereco_cobranca_uf'] = "UF";
$_['field_contato_endereco_cobranca_uf_help'] = "Campo correspondente ao Estado do cliente.";
$_['field_contato_endereco_cobranca_uf_invalid'] = "$_[field_contato_endereco_cobranca_uf] é um campo obrigatório";

$_['field_contato_endereco_cobranca_complemento'] = "Complemento";
$_['field_contato_endereco_cobranca_complemento_help'] = "Campo correspondente ao Complemento do cliente.";

$_['field_order_status_legend'] = <<<HTML
<w style="position:relative">
    Situação de pedido
    <a href="https://www.bling.com.br/gerenciador.transicoes.php" target="_blank" style="font-size:9px;white-space:nowrap">
        <b>Gerenciar <i class="fa fa-external-link" style="font-size:8px"></i></b>
    </a>
</w>
HTML;

$_['field_order_status_help'] = "Selecione a situação de pedido correspondente.";
$_['field_order_status_ignore'] = "--- Ignorar situação do pedido ---";
$_['field_order_status_none'] = <<<HTML
<i class="fa fa-exclamation-triangle"></i> Nenhuma situação de pedido encontrada
HTML;

$_['field_order_status_stock_help'] = 'Este campo ao alterar para esta situação, irá lançar ou estornar o estoque do produto';
$_['field_order_status_stock_opt_none'] = '--- Não informar ---';
$_['field_order_status_stock_opt_reduce'] = 'Lançar estoque';
$_['field_order_status_stock_opt_reverse'] = 'Estornar estoque';

$_['field_order_status_notify_help'] = 'Ao ativar este campo ao alterar para esta situação notificará por e-mail cliente, ao deixar este campo desativado a alteração de status será visível apenas para a administração';
$_['field_order_status_notify'] = <<<HTML
<span dev5-tooltip="$_[field_order_status_notify_help]">Notificar cliente? <i class="fa fa-question-circle text-primary"></i></span>
HTML;

$_['field_payment_method_legend'] = <<<HTML
<w style="position:relative">
    Métodos de pagamento
    <a href="https://www.bling.com.br/formas.pagamento.php" target="_blank" style="font-size:9px;white-space:nowrap">
        <b>Gerenciar <i class="fa fa-external-link" style="font-size:8px"></i></b>
    </a>
</w>
HTML;

$_['field_payment_method_help'] = "Selecione o método de pagamento correspondente.";
$_['field_payment_method_placeholder'] = "--- Não informar --- (autocomplete)";
$_['field_payment_method_none'] = <<<HTML
<i class="fa fa-exclamation-triangle"></i> Nenhum método de pagamento encontrado.
HTML;
$_['field_payment_method_invalid_code_format'] = "Formato de código inválido";

$_['field_payment_method_days_help'] = '<p>Prazo de pagamento em dias</p>Caso &quot;Criar parcelas?&quot; habilitado, será incrementado o prazo em cada parcela';
$_['field_payment_method_days_placeholder'] = '0';

$_['field_payment_method_regex_help'] = <<<HTML
<p>Ative essa opção para os métodos de pagamentos que possui parcelas, assim, irá buscar via Regex no primeiro comentário a quantidade de parcelas</p>Ex: &quot;1x&quot; &quot;09x&quot; &quot;12x&quot;
HTML;
$_['field_payment_method_regex'] = <<<HTML
<span dev5-tooltip="$_[field_payment_method_regex_help]">Criar parcelas? <i class="fa fa-question-circle text-primary"></i></span>
HTML;

$_['field_shipping_method_legend'] = <<<HTML
<w style="position:relative">
    Métodos de envio
    <a href="https://www.bling.com.br/central.extensoes.php#/pages/minhas-instalacoes" target="_blank" style="font-size:9px;white-space:nowrap">
        <b>Gerenciar <i class="fa fa-external-link" style="font-size:8px"></i></b>
    </a>
</w>
HTML;

$_['field_shipping_method_help'] = "Selecione o método de envio correspondente.";
$_['field_shipping_method_placeholder'] = "--- Não informar --- (autocomplete)";
$_['field_shipping_method_none'] = <<<HTML
<i class="fa fa-exclamation-triangle"></i> Nenhum método de envio encontrado.
HTML;
$_['field_shipping_method_invalid_code_format'] = "Formato de código inválido";

$_['field_shipping_method_fretePorConta_help'] = "Frete por conta";
$_['field_shipping_method_fretePorConta_opt_0'] = '0 - Contratação do Frete por conta do Remetente (CIF)';
$_['field_shipping_method_fretePorConta_opt_1'] = '1 - Contratação do Frete por conta do Destinatário (FOB)';
$_['field_shipping_method_fretePorConta_opt_2'] = '2 - Contratação do Frete por conta de Terceiros';
$_['field_shipping_method_fretePorConta_opt_3'] = '3 - Transporte Próprio por conta do Remetente';
$_['field_shipping_method_fretePorConta_opt_4'] = '4 - Transporte Próprio por conta do Destinatário';
$_['field_shipping_method_fretePorConta_opt_9'] = '9 - Sem Ocorrência de Transporte';

// -- Tab EI

$_['tab_ei'] = 'Exportar / Importar';

$_['field_ei_alert'] = <<<HTML
<b>
    <i class="fa fa-info-circle"></i> Leia com atenção:</b><br/>
    Por conta de limitações na API V3 disponibilizada pelo Bling para integração algumas informações ainda deverão ser alteradas diretamente no painel do Bling. Por favor leia todas descrições dos itens listados abaixo e para evitar conflito de informações realize as funções abaixo descritas apenas no painel do OpenCart.
</b>
HTML;

$_['field_ei_category_legend'] = 'Departamentos';

$_['field_ei_export_category'] = <<<HTML
<b><i class="fa fa-upload"></i> Eventos para exportar departamento</b><br>
<small><i>
• Envia eventos de departamentos do OpenCart para o Bling.<br>
• Os eventos "<b>Criar/Editar</b>" criarão ou atualizarão o departamento no Bling.<br>
• O evento "<b>Delete</b>" excluirá permanentemente o departamento no Bling.
</i></small>
HTML;
$_['field_ei_export_category_opt_add'] = 'Criar';
$_['field_ei_export_category_opt_edit'] = 'Editar';
$_['field_ei_export_category_opt_delete'] = 'Deletar';

$_['field_ei_product_legend'] = 'Produtos / Estoques';

$_['field_ei_export_product'] = <<<HTML
<b><i class="fa fa-upload"></i> Exportar produto</b><br>
<small><i>
• Envia eventos de produtos do OpenCart para o Bling.<br>
• Os eventos "<b>Criar/Editar</b>" criarão ou atualizarão o produto no Bling.<br>
• O evento "<b>Delete</b>" excluirá permanentemente o produto no Bling.
</i></small>
HTML;
$_['field_ei_export_product_opt_add'] = 'Criar';
$_['field_ei_export_product_opt_edit'] = 'Editar';
$_['field_ei_export_product_opt_delete'] = 'Deletar';

$_['field_ei_import_stock_callback'] = <<<HTML
<b><i class="fa fa-download"></i> Importar Estoque via Callback</b><br>
<small><i>• Recebe eventos de entrada/saída de estoque do Bling para o OpenCart.</i></small>
HTML;

$_['field_ei_export_product_with_category'] = <<<HTML
<b><i class="fa fa-cog"></i> Exportar categoria junto ao produto</b><br>
<small><i>
• Caso "<b>Habilitado</b>" enviará as categorias do produto do OpenCart para o Bling junto ao produto. Se a categoria não existir no Bling, será exportada automaticamente.<br>
• Esta opção irá preencher no Bling o campo "<b>Categoria</b>" e também as "<b>Categorias Vinculadas</b>" do canal de venda selecionado na guia $_[tab_general].
</i></small>
HTML;

$_['field_ei_export_product_with_stock'] = <<<HTML
<b><i class="fa fa-cog"></i> Exportar estoques junto ao produto</b><br>
<small><i>• Caso "<b>Habilitado</b>" gera um balanço no Bling se do Bling estoque estiver diferente do OpenCart ao exportar um produto do OpenCart para o Bling.</i></small>
HTML;

$_['field_ei_order_legend'] = 'Pedidos';

$_['field_ei_export_order'] = <<<HTML
<b><i class="fa fa-upload"></i> Exportar pedidos</b><br>
<small><i>
• Envia eventos de pedidos do OpenCart para o Bling.<br>
• Os eventos "<b>Criar/Editar/Alterar situação</b>" criarão ou atualizarão o pedido no Bling.<br> 
• O evento "<b>Delete</b>" excluirá permanentemente o pedido no Bling.
</i></small>
HTML;
$_['field_ei_export_order_opt_add'] = 'Criar';
$_['field_ei_export_order_opt_edit'] = 'Editar';
$_['field_ei_export_order_opt_delete'] = 'Deletar';
$_['field_ei_export_order_opt_status'] = 'Alterar situação';

$_['field_ei_import_order_callback'] = <<<HTML
<b><i class="fa fa-download"></i> Importar via Callback</b><br>
<small><i>• Os pedidos serão importados via callback.</i></small>
HTML;

$_['field_ei_export_order_ignore_id'] = <<<HTML
<b><i class="fa fa-cog"></i> Exportar/Importar pedidos a partir do pedido nº</b><br>
<small><i>
• Utilizado para determinar o número do pedido mínimo para ser exportado/importado.<br>
• Deixe em branco para permitir todos os pedidos.
</i></small>
HTML;
$_['field_ei_export_order_ignore_id_placeholder'] = '0';

$_['field_ei_export_order_ignore_date'] = <<<HTML
<b><i class="fa fa-cog"></i> Exportar/Importar pedidos a partir da data</b><br>
<small><i>• Utilizado para determinar a data mínima do pedido para ser importado do Bling para o OpenCart.<br>
• Deixe em branco para permitir todos os pedidos.
</i></small>
HTML;

$_['field_ei_import_order_not_found'] = <<<HTML
<b><i class="fa fa-cog"></i> Ação caso o pedido importado não exista</b><br>
<small><i>• Ação a ser tomada caso o pedido importado do Bling não exista no OpenCart.</i></small>
HTML;
$_['field_ei_import_order_not_found_opt_create'] = 'Criar';
$_['field_ei_import_order_not_found_opt_ignore'] = 'Ignorar';

$_['field_ei_update_seller_on_event_opt_none'] = 'Não atualizar';
$_['field_ei_update_seller_on_event_opt_last'] = 'Atualizar via pedido mais recente';
$_['field_ei_update_seller_on_event_opt_current'] = 'Atualizar via pedido atual';
$_['field_ei_update_seller_on_event'] = <<<HTML
<b><i class="fa fa-cog"></i> Ação para atualizar campo "<b>Vendedor</b>" no cadastro do cliente</b><br>
<small><i>
• Ação a ser tomada para atualizar o campo "<b>Vendedor</b>" no cadastro do cliente no OpenCart nos eventos de pedidos.<br>
&emsp;- <b>$_[field_ei_update_seller_on_event_opt_last]</b>: Atualizará baseado no valor do campo "Vendedor" do pedido mais recente (não cancelado).<br>
&emsp;- <b>$_[field_ei_update_seller_on_event_opt_current]</b>: Atualizará baseado no valor do campo "Vendedor" do pedido que está sendo modificado.
</i></small>
HTML;

// Tab Queue

$_['tab_queue'] = <<<HTML
<i class="fa fa-refresh"></i> Eventos
HTML;
$_['field_queue_column_timestamp'] = 'Data';
$_['field_queue_column_event'] = 'Ação';
$_['field_queue_column_status'] = 'Situação';

$_['text_queue_pending'] = <<<HTML
<i class="fa fa-list fa-fw"></i> Na fila
HTML;
$_['text_queue_processing'] = <<<HTML
<i class="fa fa-refresh fa-spin fa-fw"></i> Processando
HTML;
$_['text_queue_success'] = <<<HTML
<i class="fa fa-check-circle fa-fw"></i> Sucesso
HTML;
$_['text_queue_error'] = <<<HTML
<i class="fa fa-times-circle fa-fw"></i> Falhou
HTML;
$_['error_unknown'] = '';

$_['text_queue_export_category'] = 'Exportar categoria';
$_['text_queue_delete_category'] = 'Deletar categoria';
$_['text_queue_export_product'] = 'Exportar produto';
$_['text_queue_delete_product'] = 'Deletar produto';
$_['text_queue_export_order'] = 'Exportar pedido';
$_['text_queue_delete_order'] = 'Deletar pedido';
$_['text_queue_import_category'] = 'Importar categoria';
$_['text_queue_import_product'] = 'Importar produto';
$_['text_queue_import_order'] = 'Importar pedido';
$_['text_queue_callback_order_status'] = 'Callback de status do pedido';
$_['text_queue_callback_product_stock'] = 'Callback de estoque do produto';

// --- Product From

$_['field_product_d5bling_canais'] = "Canais de Venda";
$_['field_product_d5bling_canais_help'] = $_['field_canais_help'];
$_['field_product_d5bling_canais_column_channel_status'] = "";
$_['field_product_d5bling_canais_column_channel_name'] = "Canal de Venda";
$_['field_product_d5bling_canais_column_additional_price'] = "Preço Adicional";
$_['field_product_d5bling_canais_column_additional_price_help'] = "Informe o valor que será adicionado ao preço do produto para o canal de venda";
$_['field_product_d5bling_canais_column_additional_price_placeholder'] = "Preço Adicional";
$_['field_product_d5bling_canais_column_additional_special'] = "Preço Promocional Adicional";
$_['field_product_d5bling_canais_column_additional_special_help'] = "Informe o valor que será adicionado ao preço promocional do produto para o canal de venda";
$_['field_product_d5bling_canais_column_additional_special_placeholder'] = "Preço Promocional";
$_['field_product_d5bling_canais_empty'] = $_['field_canais_empty'];

$_['field_product_d5bling_tipo'] = "Tipo";
$_['field_product_d5bling_tipo_help'] = "Tipo do produto no Bling";
$_['field_product_form_tipo_opt_P'] = "Produto";
$_['field_product_form_tipo_opt_S'] = "Serviço";

$_['field_product_d5bling_data_validade'] = "Data de validade";
$_['field_product_d5bling_data_validade_help'] = "Data de validade do produto no Bling";

$_['field_product_d5bling_unidade'] = "Unidade";
$_['field_product_d5bling_unidade_help'] = 'Exemplo: UN, PC, KG';
$_['field_product_d5bling_unidade_placeholder'] = 'Exemplo: UN, PC, KG';
$_['field_product_d5bling_unidade_opt_UN'] = "Unidade";
$_['field_product_d5bling_unidade_opt_PC'] = "Pacote";
$_['field_product_d5bling_unidade_opt_CX'] = "Caixa";
$_['field_product_d5bling_unidade_opt_KG'] = "Quilograma";
$_['field_product_d5bling_unidade_opt_M'] = "Metro";
$_['field_product_d5bling_unidade_opt_L'] = "Litro";

$_['field_product_d5bling_deposito'] = <<<HTML
<w style="position:relative">
    Depósito
    <a href="https://www.bling.com.br/depositos.php" target="_blank" style="position:absolute;right:0;bottom:-15px;font-size:9px;white-space:nowrap">
        Gerenciar <i class="fa fa-external-link" style="font-size:8px"></i>
    </a>
</w>
HTML;
$_['field_product_d5bling_deposito_help'] = "Depósito do produto no Bling";
$_['field_product_d5bling_deposito_invalid'] = "$_[field_product_d5bling_deposito] é um campo obrigatório";

$_['field_product_d5bling_peso_liquido'] = "Peso Liquido";
$_['field_product_d5bling_peso_liquido_help'] = "Em Kg";
$_['field_product_d5bling_peso_liquido_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_volumes'] = "Qtd de Volumes";
$_['field_product_d5bling_volumes_help'] = "Quantidade total de volumes que o produto precisa ser dividido para entrega";
$_['field_product_d5bling_volumes_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_itens_por_caixa'] = "Itens p/caixa";
$_['field_product_d5bling_itens_por_caixa_help'] = "Quantidade de itens por caixa/embalagem";
$_['field_product_d5bling_itens_por_caixa_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_gtin'] = "GTIN / EAN";
$_['field_product_d5bling_gtin_help'] = "Código GTIN (GTIN-8, GTIN-12, GTIN-13 ou GTIN-14) do produto que está sendo comercializado (Apenas números)";
$_['field_product_d5bling_gtin_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_gtin_embalagem'] = "GTIN / EAN da embalagem";
$_['field_product_d5bling_gtin_embalagem_help'] = "Código GTIN (GTIN-8, GTIN-12 ou GTIN-13) da menor unidade comercializada no varejo (Apenas números)";
$_['field_product_d5bling_gtin_embalagem_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tipo_producao'] = "Produção";
$_['field_product_d5bling_tipo_producao_help'] = "Tipo de produção do produto";
$_['field_product_form_tipo_producao_opt_P'] = "Própria";
$_['field_product_form_tipo_producao_opt_T'] = "Terceiros";

$_['field_product_d5bling_condicao'] = "Condição";
$_['field_product_d5bling_condicao_help'] = "Condição do produto";
$_['field_product_form_condicao_opt_0'] = "Não especificada";
$_['field_product_form_condicao_opt_1'] = "Novo";
$_['field_product_form_condicao_opt_2'] = "Usado";

$_['field_product_d5bling_frete_gratis'] = "Frete Grátis";
$_['field_product_d5bling_frete_gratis_help'] = "Produto com frete grátis";

$_['field_product_d5bling_observacoes'] = "Observações";
$_['field_product_d5bling_observacoes_help'] = "Observações gerais sobre o produto";
$_['field_product_d5bling_observacoes_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_descricao_embalagem_discreta'] = "Descrição da Embalagem Discreta";
$_['field_product_d5bling_descricao_embalagem_discreta_help'] = "Descrição da embalagem discreta do produto";
$_['field_product_d5bling_descricao_embalagem_discreta_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_categoria_id'] = "Categoria";
$_['field_product_d5bling_categoria_id_help'] = "Categoria referente aos campos customizados, sem vínculo com as integrações multiloja";
$_['field_product_d5bling_categoria_id_placeholder'] = "Selecione a categoria (autocomplete)";

$_['field_product_d5bling_estoque_minimo'] = "Estoque Mínimo";
$_['field_product_d5bling_estoque_minimo_help'] = "Qtd mínima do produto no estoque";
$_['field_product_d5bling_estoque_minimo_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_estoque_maximo'] = "Estoque Máximo";
$_['field_product_d5bling_estoque_maximo_help'] = "Qtd máxima do produto no estoque";
$_['field_product_d5bling_estoque_maximo_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_estoque_crossdocking'] = "Estoque Cross-Docking";
$_['field_product_d5bling_estoque_crossdocking_help'] = "Quantidade de dias para o processo de distribuição em que a mercadoria recebida é redirecionada ao consumidor final sem uma armazenagem prévia.";
$_['field_product_d5bling_estoque_crossdocking_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_origem'] = "Origem";
$_['field_product_d5bling_tributacao_origem_help'] = "Origem do produto conforme ICMS";
$_['field_product_d5bling_tributacao_origem_opt_none'] = '--- Não informar ---';
$_['field_product_d5bling_tributacao_origem_opt_0'] = "0 - Nacional, exceto as indicadas nos códigos 3, 4, 5 e 8";
$_['field_product_d5bling_tributacao_origem_opt_1'] = "1 - Estrangeira - Importação direta, exceto a indicada no código 6";
$_['field_product_d5bling_tributacao_origem_opt_2'] = "2 - Estrangeira - Adquirida no mercado interno, exceto a indicada no código 7";
$_['field_product_d5bling_tributacao_origem_opt_3'] = "3 - Nacional, mercadoria ou bem com Conteúdo de Importação superior a 40% e inferior ou igual a 70%";
$_['field_product_d5bling_tributacao_origem_opt_4'] = "4 - Nacional, cuja produção tenha sido feita em conformidade com os processos produtivos básicos de que tratam as legislações citadas nos Ajustes";
$_['field_product_d5bling_tributacao_origem_opt_5'] = "5 - Nacional, mercadoria ou bem com Conteúdo de Importação inferior ou igual a 40%";
$_['field_product_d5bling_tributacao_origem_opt_6'] = "6 - Estrangeira - Importação direta, sem similar nacional, constante em lista da CAMEX";
$_['field_product_d5bling_tributacao_origem_opt_7'] = "7 - Estrangeira - Adquirida no mercado interno, sem similar nacional, constante em lista da CAMEX";
$_['field_product_d5bling_tributacao_origem_opt_8'] = "8 - Nacional, mercadoria ou bem com Conteúdo de Importação superior a 70%";

$_['field_product_d5bling_tributacao_nFCI'] = "Número FCI";
$_['field_product_d5bling_tributacao_nFCI_help'] = "Preencher o número da Ficha de Conteúdo de Importação conforme a Origem da Mercadoria (3, 5 ou 8)";
$_['field_product_d5bling_tributacao_nFCI_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_ncm'] = "NCM";
$_['field_product_d5bling_tributacao_ncm_help'] = "Exemplo: 1001.10.10";
$_['field_product_d5bling_tributacao_ncm_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_cest'] = <<<HTML
<w style="position:relative">
    CEST
    <a href="https://www.confaz.fazenda.gov.br/legislacao/convenios/2018/CV142_18" target="_blank" style="position:absolute;right:0;bottom:-15px;font-size:9px;white-space:nowrap">
        Consultar <i class="fa fa-external-link" style="font-size:8px"></i>
    </a>
</w>
HTML;
$_['field_product_d5bling_tributacao_cest_help'] = "Código Especificador da Substituição Tributária - Utilizado nas operações com substituição tributária";
$_['field_product_d5bling_tributacao_cest_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_codigoListaServicos'] = <<<HTML
<w style="position:relative">
    Código da Lista de Serviços
    <a href="https://www.bling.com.br/templates/form.lista.servicos.popup.php" target="_blank" style="position:absolute;right:0;bottom:-15px;font-size:9px;white-space:nowrap">
        Consultar <i class="fa fa-external-link" style="font-size:8px"></i>
    </a>
</w>
HTML;
$_['field_product_d5bling_tributacao_codigoListaServicos_help'] = "Preencher somente em serviços";
$_['field_product_d5bling_tributacao_codigoListaServicos_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_spedTipoItem'] = "Tipo do item";
$_['field_product_d5bling_tributacao_spedTipoItem_help'] = "Utilizado na geração do SPED - PIS/COFINS";
$_['field_product_d5bling_tributacao_spedTipoItem_opt_none'] = '--- Não informar ---';
$_['field_product_d5bling_tributacao_spedTipoItem_opt_00'] = "00 - Mercadoria para Revenda";
$_['field_product_d5bling_tributacao_spedTipoItem_opt_01'] = "01 - Matéria-Prima";
$_['field_product_d5bling_tributacao_spedTipoItem_opt_02'] = "02 - Embalagem";
$_['field_product_d5bling_tributacao_spedTipoItem_opt_03'] = "03 - Produto em Processo";
$_['field_product_d5bling_tributacao_spedTipoItem_opt_04'] = "04 - Produto Acabado";
$_['field_product_d5bling_tributacao_spedTipoItem_opt_05'] = "05 - Subproduto";
$_['field_product_d5bling_tributacao_spedTipoItem_opt_06'] = "06 - Produto Intermediário";
$_['field_product_d5bling_tributacao_spedTipoItem_opt_07'] = "07 - Material de Uso e Consumo";
$_['field_product_d5bling_tributacao_spedTipoItem_opt_08'] = "08 - Ativo Imobilizado";
$_['field_product_d5bling_tributacao_spedTipoItem_opt_09'] = "09 - Serviços";
$_['field_product_d5bling_tributacao_spedTipoItem_opt_10'] = "10 - Outros insumos";
$_['field_product_d5bling_tributacao_spedTipoItem_opt_99'] = "99 - Outras";

$_['field_product_d5bling_tributacao_codigoItem'] = "Código do Item";
$_['field_product_d5bling_tributacao_codigoItem_help'] = "Preencher somente em Serviços (06 21 22)";
$_['field_product_d5bling_tributacao_codigoItem_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_percentualTributos'] = "% Tributos";
$_['field_product_d5bling_tributacao_percentualTributos_help'] = "Alíquota de valor aproximado dos tributos";
$_['field_product_d5bling_tributacao_percentualTributos_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_valorBaseStRetencao'] = "Valor base ICMS ST - retenção";
$_['field_product_d5bling_tributacao_valorBaseStRetencao_help'] = "Esse campo deve ser preenchido com o valor a ser utilizado para retenção do ICMS ST na venda, por unidade.";
$_['field_product_d5bling_tributacao_valorBaseStRetencao_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_valorStRetencao'] = "Valor ICMS ST para retenção";
$_['field_product_d5bling_tributacao_valorStRetencao_help'] = "Esse campo deve ser preenchido com o valor a ser utilizado para retenção do ICMS ST na venda, por unidade.";
$_['field_product_d5bling_tributacao_valorStRetencao_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_valorICMSSubstituto'] = "Valor ICMS próprio do substituto";
$_['field_product_d5bling_tributacao_valorICMSSubstituto_help'] = "Esse campo deve ser preenchido com o valor a ser utilizado para ICMS próprio do substituto na venda, por unidade.";
$_['field_product_d5bling_tributacao_valorICMSSubstituto_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_codigoExcecaoTipi'] = "Código exceção da TIPI";
$_['field_product_d5bling_tributacao_codigoExcecaoTipi_help'] = "Preencher de acordo com o código EX da TIPI.";
$_['field_product_d5bling_tributacao_codigoExcecaoTipi_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_classeEnquadramentoIpi'] = <<<HTML
<w style="position:relative">
    Classe de Enquadramento do IPI
    <a href="https://www.bling.com.br/templates/form.lista.enquadramento.ipi.popup.php" target="_blank" style="position:absolute;right:0;bottom:-15px;font-size:9px;white-space:nowrap">
        Consultar <i class="fa fa-external-link" style="font-size:8px"></i>
    </a>
</w>
HTML;
$_['field_product_d5bling_tributacao_classeEnquadramentoIpi_help'] = "Preencher somente para bebidas e cigarros.";
$_['field_product_d5bling_tributacao_classeEnquadramentoIpi_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_valorIpiFixo'] = "Valor IPI fixo";
$_['field_product_d5bling_tributacao_valorIpiFixo_help'] = "Utilizado na geração do SPED - PIS/COFINS.";
$_['field_product_d5bling_tributacao_valorIpiFixo_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_codigoSeloIpi'] = "Código do selo do IPI";
$_['field_product_d5bling_tributacao_codigoSeloIpi_help'] = "Preencher somente para bebidas e cigarros.";
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_none'] = 'Não se aplica';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_8610-09'] = '8610-09 - Produto Estrangeiro';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9710-01'] = '9710-01 - Produto Nacional';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9710-10'] = '9710-10 - Produto Nacional para Exportação - Tipo 1';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9710-11'] = '9710-11 - Produto Nacional para Exportação - Tipo 2';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9710-12'] = '9710-12 - Produto Nacional para Exportação - Tipo 3';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9729-11'] = '9729-11 - Uísque Verde';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9729-12'] = '9729-12 - Uísque Azul';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9729-13'] = '9729-13 - Uísque Vermelho';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9729-14'] = '9729-14 - Uísque Amarelo';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9729-21'] = '9729-21 - Uísque Miniatura Verde';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9729-22'] = '9729-22 - Uísque Miniatura Azul';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9729-23'] = '9729-23 - Uísque Miniatura Vermelho';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9729-24'] = '9729-24 - Uísque Miniatura Amarelo';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9737-11'] = '9737-11 - Bebida Alcoólica Laranja';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9737-12'] = '9737-12 - Bebida Alcoólica Cinza';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9737-13'] = '9737-13 - Bebida Alcoólica Marrom';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9737-14'] = '9737-14 - Bebida Alcoólica Verde';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9737-15'] = '9737-15 - Bebida Alcoólica Vermelho';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9737-16'] = '9737-16 - Bebida Alcoólica Azul Marinho';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9737-21'] = '9737-21 - Bebida Alcoólica Miniatura Verde';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9737-22'] = '9737-22 - Bebida Alcoólica Miniatura Vermelho';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9737-23'] = '9737-23 - Bebida Alcoólica Miniatura Azul Marinho';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9745-11'] = '9745-11 - Aguardente Laranja';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9745-12'] = '9745-12 - Aguardente Azul';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9745-13'] = '9745-13 - Aguardente Violeta';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9822-11'] = '9822-11 - Vinho Verde';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9822-12'] = '9822-12 - Vinho Vermelho';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9822-13'] = '9822-13 - Vinho amarelo';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9829-11'] = '9829-11 - Uísque Verde';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9829-12'] = '9829-12 - Uísque Azul';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9829-13'] = '9829-13 - Uísque Vermelho';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9829-14'] = '9829-14 - Uísque Amarelo';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9829-21'] = '9829-21 - Uísque Miniatura Verde';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9829-22'] = '9829-22 - Uísque Miniatura Azul';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9829-23'] = '9829-23 - Uísque Miniatura Vermelho';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9829-24'] = '9829-24 - Uísque Miniatura Amarelo';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9837-11'] = '9837-11 - Bebida Alcoólica Laranja';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9837-12'] = '9837-12 - Bebida Alcoólica Cinza';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9837-13'] = '9837-13 - Bebida Alcoólica Marrom';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9837-14'] = '9837-14 - Bebida Alcoólica Verde';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9837-15'] = '9837-15 - Bebida Alcoólica Vermelho';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9837-16'] = '9837-16 - Bebida Alcoólica Azul Marinho';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9837-21'] = '9837-21 - Bebida Alcoólica Miniatura Verde';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9837-22'] = '9837-22 - Bebida Alcoólica Miniatura Vermelho';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9837-23'] = '9837-23 - Bebida Alcoólica Miniatura Azul Marinho';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9845-11'] = '9845-11 - Aguardente Laranja';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9845-12'] = '9845-12 - Aguardente Azul';
$_['field_product_d5bling_tributacao_codigoSeloIpi_opt_9845-13'] = '9845-13 - Aguardente Violeta';

$_['field_product_d5bling_tributacao_valorPisFixo'] = "Valor PIS fixo";
$_['field_product_d5bling_tributacao_valorPisFixo_help'] = "Preencher somente quando possuir valor fixo por unidade";
$_['field_product_d5bling_tributacao_valorPisFixo_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_valorCofinsFixo'] = "Valor COFINS fixo";
$_['field_product_d5bling_tributacao_valorCofinsFixo_help'] = "Preencher somente quando possuir valor fixo por unidade";
$_['field_product_d5bling_tributacao_valorCofinsFixo_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_codigoANP'] = "Código ANP";
$_['field_product_d5bling_tributacao_codigoANP_help'] = "Código da Agência Nacional do Petróleo, Gás Natural e Biocombustíveis";
$_['field_product_d5bling_tributacao_codigoANP_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_descricaoANP'] = "Descrição ANP";
$_['field_product_d5bling_tributacao_descricaoANP_help'] = "Descrição da Agência Nacional do Petróleo, Gás Natural e Biocombustíveis";
$_['field_product_d5bling_tributacao_descricaoANP_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_percentualGLP'] = "% GLP";
$_['field_product_d5bling_tributacao_percentualGLP_help'] = "Percentual de Gás Liquefeito de Petróleo";
$_['field_product_d5bling_tributacao_percentualGLP_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_percentualGasNacional'] = "% Gás Nacional";
$_['field_product_d5bling_tributacao_percentualGasNacional_help'] = "Percentual de Gás Nacional";
$_['field_product_d5bling_tributacao_percentualGasNacional_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_percentualGasImportado'] = "% Gás Importado";
$_['field_product_d5bling_tributacao_percentualGasImportado_help'] = "Percentual de Gás Importado";
$_['field_product_d5bling_tributacao_percentualGasImportado_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_valorPartida'] = "Valor de Partida";
$_['field_product_d5bling_tributacao_valorPartida_help'] = "Valor de Partida";
$_['field_product_d5bling_tributacao_valorPartida_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_tipoArmamento'] = "Tipo de Armamento";
$_['field_product_d5bling_tributacao_tipoArmamento_help'] = "Tipo de armamento";
$_['field_product_d5bling_tributacao_tipoArmamento_opt_none'] = 'Não se aplica';
$_['field_product_d5bling_tributacao_tipoArmamento_opt_0'] = "Uso permitido";
$_['field_product_d5bling_tributacao_tipoArmamento_opt_1'] = "Uso restrito";

$_['field_product_d5bling_tributacao_descricaoCompletaArmamento'] = "Descrição Completa do Armamento";
$_['field_product_d5bling_tributacao_descricaoCompletaArmamento_help'] = "Descrição completa do armamento";
$_['field_product_d5bling_tributacao_descricaoCompletaArmamento_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_dadosAdicionais'] = "Informações Adicionais";
$_['field_product_d5bling_tributacao_dadosAdicionais_help'] = "Campo referente a tag infAdProd da nota fiscal.";
$_['field_product_d5bling_tributacao_dadosAdicionais_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_tributacao_grupoProduto_id'] = <<<HTML
<w style="position:relative">
    Grupo de Produtos
    <a href="https://www.bling.com.br/produto.grupo.php" target="_blank" style="position:absolute;right:0;bottom:-15px;font-size:9px;white-space:nowrap">
        Gerenciar <i class="fa fa-external-link" style="font-size:8px"></i>
    </a>
</w>
HTML;
$_['field_product_d5bling_tributacao_grupoProduto_id_help'] = "Grupo de produtos do Bling";
$_['field_product_d5bling_tributacao_grupoProduto_id_placeholder'] = "--- Não informar --- (autocomplete)";

$_['field_product_d5bling_midia_video_url'] = "Vídeo";
$_['field_product_d5bling_midia_video_url_help'] = "Vídeo do produto, utilizado na exportação do produto para lojas virtuais.";
$_['field_product_d5bling_midia_video_url_placeholder'] = "--- Não informar ---";

$_['field_product_d5bling_campos_customizados_legend'] = "Campos Customizados";

$_['field_invalid_required'] = "Campo obrigatório";

// --- Customer Form / Order From
$_['field_customer_seller_inner'] = 'Vendedor';
$_['field_customer_seller'] = <<<HTML
<style>.modal w>a{position:unset!important}</style>
<w style="position:relative">
    $_[field_customer_seller_inner]
    <a href="https://www.bling.com.br/b/vendedores.php#list" target="_blank" style="position:absolute;right:0;bottom:-15px;font-size:9px;white-space:nowrap">
        Gerenciar <i class="fa fa-external-link" style="font-size:8px"></i>
    </a>
</w>
HTML;

// --- EI From

$_['button_ei_process'] = 'Iniciar';
$_['button_ei_restart'] = 'Re-iniciar';
$_['button_ei_continue'] = 'Continuar operação anterior';
$_['button_ei_approve'] = 'Aprovar';
$_['button_ei_cancel'] = 'Cancelar';

$_['text_ei_canceled'] = "Operação cancelada";
$_['text_ei_waiting'] = "Aguarde...";
$_['text_ei_getting'] = "Buscando... {{ total }}";
$_['text_ei_getting_finished'] = "Total de {{ total }} encontrado(s)";
$_['text_ei_approve_selected'] = "{{ total }} selecionado(s)";
$_['text_ei_label'] = "Informações";
$_['text_ei_status'] = "Situação";
$_['text_ei_approve'] = "Aprovando... {{ total }}";
$_['text_ei_approve_finished'] = "Total de {{ total }} aprovado(s)";
$_['text_ei_error'] = <<<HTML
Não foi possível continuar.<br><br>
Atualize a página e tente novamente.
HTML;

$_['text_ei_total_success'] = "sucesso(s)";
$_['text_ei_total_queue'] = "na fila";
$_['text_ei_total_fail'] = "falha(s)";
$_['text_ei_total_unknown'] = "desconhecido(s)";

$_['text_ei_unknown'] = "Unknown";
$_['text_ei_queue'] = <<<HTML
<i class="fa fa-list fa-fw"></i> Na fila
HTML;
$_['text_ei_success'] = <<<HTML
<i class="fa fa-check-circle fa-fw"></i> Sucesso
HTML;
$_['text_ei_fail'] = <<<HTML
<i class="fa fa-times-circle fa-fw"></i> Falhou
HTML;

$_['text_ei_action_legend'] = '';

$_['heading_title_ei_export_categories'] = "Exportar Categorias (OpenCart → Bling)";
$_['field_ei_export_categories_filter_legend'] = "Filtros OpenCart";
$_['field_ei_export_categories_id'] = "ID da Categoria no OpenCart";
$_['field_ei_export_categories_id_placeholder'] = "(aperte enter para adicionar)";
$_['field_ei_export_categories_name'] = "Nome da Categoria no OpenCart";
$_['field_ei_export_categories_name_placeholder'] = "(autocomplete)";
$_['field_ei_export_categories_status'] = "Situação da Categoria no OpenCart";
$_['field_ei_export_categories_status_opt_none'] = 'Todas as situações';
$_['field_ei_export_categories_date_added'] = "Data de Criação da Categoria no OpenCart (De - Até)";
$_['field_ei_export_categories_date_modified'] = "Data de Modificação da Categoria no OpenCart (De - Até)";

$_['heading_title_ei_export_products'] = "Exportar Produtos (OpenCart → Bling)";
$_['field_ei_export_products_filter_legend'] = "Filtros OpenCart";
$_['field_ei_export_products_id'] = "ID do Produto no OpenCart";
$_['field_ei_export_products_id_placeholder'] = "(aperte enter para adicionar)";
$_['field_ei_export_products_name'] = "Nome do Produto no OpenCart";
$_['field_ei_export_products_name_placeholder'] = "(autocomplete)";
$_['field_ei_export_products_status'] = "Situação do Produto no OpenCart";
$_['field_ei_export_products_status_opt_none'] = 'Todas as situações';
$_['field_ei_export_products_date_added'] = "Data de Criação do Produto no OpenCart (De - Até)";
$_['field_ei_export_products_date_modified'] = "Data de Modificação do Produto no OpenCart (De - Até)";
$_['field_ei_export_products_config_legend'] = "Configurações";

$_['heading_title_ei_export_orders'] = "Exportar Pedidos (OpenCart → Bling)";
$_['field_ei_export_orders_filter_legend'] = "Filtros OpenCart";
$_['field_ei_export_orders_id'] = "ID do Pedido no OpenCart";
$_['field_ei_export_orders_id_placeholder'] = "(aperte enter para adicionar)";
$_['field_ei_export_orders_status'] = "Situação do Pedido no OpenCart";
$_['field_ei_export_orders_date_added'] = "Data de Criação do Pedido no OpenCart (De - Até)";
$_['field_ei_export_orders_date_modified'] = "Data de Modificação do Pedido no OpenCart (De - Até)";
$_['field_ei_export_orders_config_legend'] = "Configurações";

$_['heading_title_ei_import_categories'] = "Importar Categorias (Bling → OpenCart)";
$_['field_ei_import_categories_filter_legend'] = "Filtros Bling";
$_['field_ei_import_categories_bling_id'] = "ID da Categoria no Bling";
$_['field_ei_import_categories_bling_id_placeholder'] = "(aperte enter para adicionar)";
$_['field_ei_import_categories_name'] = "Nome da Categoria no Bling";
$_['field_ei_import_categories_name_placeholder'] = "(autocomplete)";

$_['heading_title_ei_import_products'] = "Importar Produtos (Bling → OpenCart)";
$_['field_ei_import_products_filter_legend'] = "Filtros Bling";
$_['field_ei_import_products_bling_id'] = "ID do Produto no Bling";
$_['field_ei_import_products_bling_id_placeholder'] = "(aperte enter para adicionar)";
$_['field_ei_import_products_name'] = "Nome do Produto no Bling";
$_['field_ei_import_products_name_placeholder'] = "(autocomplete)";
$_['field_ei_import_products_codigo'] = "Código do Produto no Bling";
$_['field_ei_import_products_codigo_placeholder'] = "(aperte enter para adicionar)";
$_['field_ei_import_products_status'] = "Situação da Categoria no Bling";
$_['field_ei_import_products_status_opt_none'] = 'Todas as situações';
$_['field_ei_import_products_date_added'] = "Data de Criação do Produto no Bling (De - Até)";
$_['field_ei_import_products_date_modified'] = "Data de Modificação do Produto no Bling (De - Até)";
$_['field_ei_import_products_config_legend'] = "Configurações";
$_['field_ei_import_products_found'] = "Ação caso o produto seja EXISTA no OpenCart?";
$_['field_ei_import_products_found_opt_ignore'] = "Ignorar";
$_['field_ei_import_products_found_opt_stock'] = "Atualizar estoque apenas";
$_['field_ei_import_products_found_opt_replace'] = "Atualizar todos os dados";
$_['field_ei_import_products_not_found'] = "Ação caso o produto seja NÂO EXISTA no OpenCart?";
$_['field_ei_import_products_not_found_opt_ignore'] = "Ignorar";
$_['field_ei_import_products_not_found_opt_create'] = "Criar";
$_['field_ei_import_products_category'] = "Ação caso a categoria NÂO EXISTA no OpenCart?";
$_['field_ei_import_products_category_opt_ignore'] = "Ignorar";
$_['field_ei_import_products_category_opt_create'] = "Criar";
$_['field_ei_import_products_image'] = "Baixar imagens?";

$_['heading_title_ei_import_orders'] = "Importar Pedidos (Bling → OpenCart)";
$_['field_ei_import_orders_filter_legend'] = "Filtros Bling";
$_['field_ei_import_orders_bling_id'] = "ID do Pedido no Bling";
$_['field_ei_import_orders_bling_id_placeholder'] = "(aperte enter para adicionar)";
$_['field_ei_import_orders_status'] = "Situação do Pedido no Bling";
$_['field_ei_import_orders_numero_loja'] = "Número Loja Virtual no Bling";
$_['field_ei_import_orders_numero_loja_placeholder'] = "(aperte enter para adicionar)";
$_['field_ei_import_orders_date_added'] = "Data de Criação do Pedido no Bling (De - Até)";
$_['field_ei_import_orders_date_modified'] = "Data de Modificação do Pedido no Bling (De - Até)";
$_['field_ei_import_orders_channel_id'] = "Canal de Venda no Bling";
$_['field_ei_import_orders_channel_id_opt_none'] = "Todos os canais de venda";
$_['field_ei_import_orders_config_legend'] = "Configurações";
$_['field_ei_import_orders_found'] = "Ação caso o pedido seja EXISTA no OpenCart?";
$_['field_ei_import_orders_found_opt_ignore'] = "Ignorar";
$_['field_ei_import_orders_found_opt_status'] = "Atualizar situação apenas";
$_['field_ei_import_orders_found_opt_replace'] = "Atualizar todos os dados";
$_['field_ei_import_orders_not_found'] = "Ação caso o pedido seja NÂO EXISTA no OpenCart?";
$_['field_ei_import_orders_not_found_opt_ignore'] = "Ignorar";
$_['field_ei_import_orders_not_found_opt_create'] = "Criar";

\Dev5\OpenCart::compile($_);
