<section style="display:none!important">
    <?= @$header ?>
    <?= @$footer ?>
</section>
<div class="container-fluid" style="padding:15px">
    <h1 class="text-center">
        <?= $_["heading_title_ei_$type"] ?>
    </h1>

    <?php if (@$event === 'form'): ?>
        <style>
            label, label + div {
                width: 100% !important
            }
        </style>
        <form action="<?= @$href_ei_event ?>&event=getting-submit" method="post" id="form-ei" class="form-horizontal">
            <?= @$form ?>
            <fieldset class="dev5-fieldset">
                <legend><?= $_['text_ei_action_legend'] ?></legend>

                <?php if (@$continue): ?>
                    <div class="pull-left float-start">
                        <a href="<?= @$href_ei_event ?>&event=<?= @$continue ?>" class="btn btn-warning btn-lg">
                            <?= $_['button_ei_continue'] ?>
                        </a>
                    </div>
                <?php endif ?>

                <div class="pull-right float-end">
                    <button id="ei-submit" type="submit" class="btn btn-primary btn-lg">
                        <?= $_[@$continue ? 'button_ei_restart' : 'button_ei_process'] ?>
                    </button>
                </div>
            </fieldset>
        </form>
        <script type="module">
            $.dev5.form.onupdate(() => {
                let disabled = $('dev5-app .has-error').length > 0;
                $('#ei-submit').toggleClass('disabled', disabled).prop('disabled', disabled);
            });
        </script>
    <?php endif ?>

    <?php if (@$event === 'approve-form'): ?>
        <style>
            .table-responsive {
                max-height: calc(100vh - 150px);
                overflow: auto;
                margin-top: 25px
            }

            th:first-child, td:first-child {
                width: 1%;
                vertical-align: middle !important
            }

            .pull-left.float-start {
                position: absolute;
                bottom: 25px;
                left: 15px;
                font-size: 1.25em
            }

            .pull-right.float-end {
                position: absolute;
                right: 15px;
                bottom: 15px
            }

            thead th {
                position: sticky;
                top: 0;
                z-index: 1;
                background-color: #fff;
                border: 0 !important;
                box-shadow: inset 0 -1px 0 #ddd
            }

            tbody tr {
                cursor: pointer
            }

            tbody tr:hover * {
                font-weight: 600
            }

            tbody tr:not(:has(input:checked)) td + td {
                opacity: .5
            }
        </style>
        <form action="<?= @$href_ei_event ?>&event=approve-submit" method="post" id="form-ei" class="form-horizontal">
            <div class="table-responsive">
                <table class="table table-sm table-condensed table-hover">
                    <thead>
                        <tr>
                            <th>
                                <label>
                                    <input type="checkbox" checked="checked" id="ei-toggle-all"/>
                                </label>
                            </th>
                            <th><?= $_['text_ei_label'] ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach (@$items as $item): ?>
                            <tr>
                                <td>
                                    <label>
                                        <input type="checkbox" name="ei[]"
                                               value="<?= @$item['id'] ?>" <?= @$item['status'] > 0 ? 'checked="checked"' : '' ?>/>
                                    </label>
                                </td>
                                <td><?= @$item['label'] ?></td>
                            </tr>
                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>
            <div class="pull-left float-start" id="ei-status"></div>
            <div class="pull-right float-end">
                <button id="ei-submit" type="submit" class="btn btn-primary btn-lg">
                    <?= $_['button_ei_approve'] ?>
                </button>
            </div>
        </form>
        <script type="module">
            $('tbody tr input').on('click', e => e.stopPropagation());
            $('tbody tr').on('click', function () {
                $(this).find('input').prop('checked', !$(this).find('input').prop('checked')).trigger('input').focus()
            });
            $('#ei-toggle-all').on('input', () => {
                $('[name="ei[]"]').prop('checked', $('#ei-toggle-all').prop('checked')).trigger('input')
            });
            $('[name="ei[]"]').on('input', () => {
                let total = $('[name="ei[]"]:checked').length;
                $('#ei-toggle-all').prop('checked', total === $('[name="ei[]"]').length);

                $('#ei-status').html(`<?= $_['text_ei_approve_selected'] ?>`.replace(/\{\{\s*total\s*}}/i, total));
                $('#ei-submit').toggleClass('disabled', total < 1).prop('disabled', total < 1);
            }).trigger('input');
        </script>
    <?php endif ?>

    <?php if (@$event === 'next-form'): ?>
        <style>
            #ei {
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                font-size: 20px;
                text-align: center
            }
        </style>
        <div id="ei">
            <p>
                <i id="ei-icon" class="fa fa-refresh fa-spin"></i>
                <span id="ei-status"><?= $_['text_ei_waiting'] ?></span>
            </p>
            <a id="ei-cancel" class="btn btn-sm btn-danger" href="<?= @$href_ei_event ?>&event=cancel">
                <?= $_['button_ei_cancel'] ?>
            </a>
        </div>
        <script type="text/javascript">
            let error = 0;
            (function next() {
                $.ajax({
                    url: `<?= @$href_ei_event_next ?>`,
                    type: 'GET',
                    dataType: 'json',
                    timeout: 2000,
                    complete(xhr) {
                        let json = xhr.responseJSON;
                        if (xhr.status === 200 && json?.status !== undefined) {
                            error = 0;
                            switch (json.status) {
                                case <?= \Dev5\Library\Bling\EIEntity\Payload::NONE ?>:
                                    $('#ei-icon').removeClass('fa-refresh fa-spin').addClass('fa-times');
                                    $('#ei-status').html(`<?= $_['text_ei_canceled'] ?>`);
                                    $('#ei-cancel').hide();
                                    setTimeout(window.close, 2000);
                                    return;

                                case <?= \Dev5\Library\Bling\EIEntity\Payload::GETTING_WAITING ?>:
                                case <?= \Dev5\Library\Bling\EIEntity\Payload::GETTING_RUNNING ?>:
                                    $('#ei-status').html(json.total > 0
                                        ? `<?= $_['text_ei_getting'] ?>`.replace(/\{\{\s*total\s*}}/i, json.total)
                                        : `<?= $_['text_ei_waiting'] ?>`
                                    );
                                    break;

                                case <?= \Dev5\Library\Bling\EIEntity\Payload::GETTING_FINISHED ?>:
                                    $('#ei-icon').removeClass('fa-refresh fa-spin').addClass('fa-check-circle');
                                    $('#ei-status').html(`<?= $_['text_ei_getting_finished'] ?>`.replace(/\{\{\s*total\s*}}/i, json.total));
                                    setTimeout(() => window.location.href = '<?= @$href_ei_event ?>&event=approve-form', 2000);
                                    return;

                                case <?= \Dev5\Library\Bling\EIEntity\Payload::APPROVE_WAITING ?>:
                                case <?= \Dev5\Library\Bling\EIEntity\Payload::APPROVE_RUNNING ?>:
                                    $('#ei-status').html(json.total > 0
                                        ? `<?= $_['text_ei_approve'] ?>`.replace(/\{\{\s*total\s*}}/i, json.total)
                                        : `<?= $_['text_ei_waiting'] ?>`
                                    );
                                    break;

                                case <?= \Dev5\Library\Bling\EIEntity\Payload::APPROVE_FINISHED ?>:
                                    $('#ei-icon').removeClass('fa-refresh fa-spin').addClass('fa-check-circle');
                                    $('#ei-status').html(`<?= $_['text_ei_approve_finished'] ?>`.replace(/\{\{\s*total\s*}}/i, json.total));
                                    setTimeout(() => window.location.href = '<?= @$href_ei_event ?>&event=summary', 2000);
                                    return;
                            }
                        }

                        if (error++ > 10) {
                            $('#ei-icon').removeClass('fa-refresh fa-spin').addClass('fa-exclamation-triangle');
                            $('#ei-status').html(`<?= $_['text_ei_error'] ?>`);
                            $('#ei-cancel').hide();
                            return;
                        }

                        setTimeout(next, 100);
                    }
                })
            })()
        </script>
    <?php endif ?>

    <?php if (@$event === 'summary'): ?>
        <style>
            .ei-summary td:last-child {
                width: 1%;
                text-align: right
            }

            .ei-summary-totals{
                display:flex;
                width:100%;
                flex-direction: row;
                justify-content: center;
                align-items: center;
                height: 50px;
                font-size: 1.3rem;
                gap: 5px
            }
        </style>

        <div class="ei-summary-totals">
            <div class="label label-success"><?= @$totals['success'] ?: 0 ?> <?= $_['text_ei_total_success'] ?></div>
            <div class="label label-primary"><?= @$totals['queue'] ?: 0 ?> <?= $_['text_ei_total_queue'] ?></div>
            <div class="label label-danger"><?= @$totals['fail'] ?: 0 ?> <?= $_['text_ei_total_fail'] ?></div>
            <?php if (!empty($totals['unknown'])): ?>
                <div class="label label-default"><?= @$totals['unknown'] ?: 0 ?> <?= $_['text_ei_total_unknown'] ?></div>
            <?php endif ?>
        </div>

        <div class="table-responsive ei-summary">
            <table class="table table-sm table-condensed table-hover">
                <thead>
                <tr>
                    <th><?= $_['text_ei_label'] ?></th>
                    <th><?= $_['text_ei_status'] ?></th>
                </tr>
                </thead>
                <tbody>
                <?php foreach (@$items as $item): ?>
                    <tr>
                        <td><?= @$item['label'] ?></td>
                        <td>
                            <?php if ($item['status'] == \Dev5\Library\Bling\EIEntity::SUCCESS): ?>
                                <span class="label label-success"><?= $_['text_ei_success'] ?></span>
                            <?php elseif ($item['status'] == \Dev5\Library\Bling\EIEntity::QUEUE): ?>
                                <span class="label label-primary"><?= $_['text_ei_queue'] ?></span>
                            <?php elseif ($item['status'] == \Dev5\Library\Bling\EIEntity::FAIL): ?>
                                <span class="label label-danger"><?= $_['text_ei_fail'] ?></span>
                            <?php else: ?>
                                <span class="label label-default"><?= $_['text_ei_unknown'] ?></span>
                            <?php endif ?>
                        </td>
                    </tr>
                <?php endforeach ?>
                </tbody>
            </table>
        </div>
    <?php endif ?>
</div>