<?php

/**
 * This file is part of Dev5 Integração ERP Bling API V3 for OpenCart
 *
 * @author    Dev5™ <developer@dev5.com.br>
 * @copyright Dev5™ 2025. Todos os direitos reservados.
 * @license   Distribuição/reprodução não autorizada estará sujeita às penas das leis 9609/98 e 9610/98
 * @link      https://dev5.com.br/integracao-erp-bling-api-v3
 * @version   4.0.6
 */

namespace Dev5\Library\Bling;

abstract class BaseEntity extends \Dev5\OpenCart\BaseEntity
{
    /**
     * @var array<class-string, bool>
     */
    private static $ignored = [];

    /**
     * @param bool|null $status
     * @return bool
     */
    public static function ignore($status = null)
    {
        func_num_args() > 0 && self::$ignored[static::class] = $status;
        return !empty(self::$ignored[static::class]);
    }

    /**
     * @param array|int $find
     * @return static
     */
    public static function getInstance($find = null)
    {
        return ($find ? static::findOne($find) : null)
            ?: static::fromArray(is_array($find) ? $find : [static::proxy()->table->getPrimary() => $find]);
    }

    /**
     * @param array $value
     * @return array|null
     */
    protected function filterNullable($value)
    {
        return array_filter($value, static function ($value) {
            return $value !== null && ($value !== '');
        }) ?: null;
    }

    /**
     * @param mixed $array
     * @param string|string[]|int|int[] $keys
     * @param mixed $default
     * @param callable|null $callback
     * @return mixed
     */
    protected function getValue($array, $keys, $default = null, $callback = null)
    {
        !is_array($keys) && $keys = [$keys];

        $value = $array;
        do {
            $key = array_shift($keys);

            if (!$value || !is_array($value) || !array_key_exists($key, $value)) {
                $value = null;
                break;
            }

            $value = $value[$key];
        } while ($keys);

        if ($value === null) {
            return $default;
        }

        return $callback ? invoker_once($callback, [$value]) : $value;
    }

    /**
     * @return string
     */
    public function getColumnCategoryTop()
    {
        static $column_top = null;

        $column_top === null && $column_top = $this->dev5->db->query('SHOW COLUMNS FROM ' . DB_PREFIX . 'category WHERE Field = "top"')->count() // phpcs:ignore
            ? "c.top"
            : 'NULL';

        return $column_top;
    }

    /**
     * @return string
     */
    public function getColumnOptionSKU()
    {
        static $column_sku = null;

        $column_sku === null && $column_sku = $this->dev5->db->query('SHOW COLUMNS FROM ' . DB_PREFIX . 'product_option_value WHERE Field = "sku"')->count() // phpcs:ignore
            ? "pov.sku"
            : 'NULL';

        return $column_sku;
    }

    /**
     * @return string
     */
    public function getColumnOptionLocation()
    {
        static $column_location = null;

        $column_location === null && $column_location = $this->dev5->db->query('SHOW COLUMNS FROM ' . DB_PREFIX . 'product_option_value WHERE Field = "location"')->count() // phpcs:ignore
            ? "pov.location"
            : 'NULL';

        return $column_location;
    }

    /**
     * @return int[]
     */
    public function getLanguages()
    {
        static $languages = null;

        null === $languages
        && $languages = array_column($this->model_localisation_language->getLanguages(), 'language_id');

        return $languages;
    }
}
