<?php

/**
 * This file is part of Dev5 Integração ERP Bling API V3 for OpenCart
 *
 * @author    Dev5™ <developer@dev5.com.br>
 * @copyright Dev5™ 2025. Todos os direitos reservados.
 * @license   Distribuição/reprodução não autorizada estará sujeita às penas das leis 9609/98 e 9610/98
 * @link      https://dev5.com.br/integracao-erp-bling-api-v3
 * @version   4.0.6
 */

namespace Dev5\Library\Bling\EIEntity;

use Dev5\Library\Bling\EIEntity;

final class Payload
{
    const NONE = -1; // phpcs:ignore
    const GETTING_WAITING = 0; // phpcs:ignore
    const GETTING_RUNNING = 1; // phpcs:ignore
    const GETTING_FINISHED = 2; // phpcs:ignore
    const APPROVE_WAITING = 3; // phpcs:ignore
    const APPROVE_RUNNING = 4; // phpcs:ignore
    const APPROVE_FINISHED = 5; // phpcs:ignore

    /**
     * @var int
     */
    public $status = self::NONE;

    /**
     * @var string
     */
    public $type = null;

    /**
     * @var mixed
     */
    public $input = null;

    /**
     * @var int
     */
    public $cursor = 0;

    /**
     * @var int
     */
    public $total = 0;

    /**
     * @var int|null
     */
    public $timestamp = null;

    /**
     * @return self
     */
    public static function emptyPayload()
    {
        EIEntity::truncate();

        $payload = new self();
        $payload->save();
        return $payload;
    }

    /**
     * @return self
     */
    public static function currentPayload()
    {
        return hydrate_unserialize(\Dev5\OpenCart::setting("bling_ei") ?: [], self::class);
    }

    public function save()
    {
        $this->timestamp = time();
        \Dev5\OpenCart::setting("bling_ei", hydrate_serialize($this));
    }
}
