<?php
/*
 * MundiAPILib
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace MundiAPILib\Models;

use JsonSerializable;
use MundiAPILib\Utils\DateTimeHelper;

/**
 *Response object for getting the shipping data
 */
class GetShippingResponse implements JsonSerializable
{
    /**
     * @todo Write general description for this property
     * @required
     * @var integer $amount public property
     */
    public $amount;

    /**
     * @todo Write general description for this property
     * @required
     * @var string $description public property
     */
    public $description;

    /**
     * @todo Write general description for this property
     * @required
     * @maps recipient_name
     * @var string $recipientName public property
     */
    public $recipientName;

    /**
     * @todo Write general description for this property
     * @required
     * @maps recipient_phone
     * @var string $recipientPhone public property
     */
    public $recipientPhone;

    /**
     * @todo Write general description for this property
     * @required
     * @var \MundiAPILib\Models\GetAddressResponse $address public property
     */
    public $address;

    /**
     * Data máxima de entrega
     * @maps max_delivery_date
     * @factory \MundiAPILib\Utils\DateTimeHelper::fromRfc3339DateTime
     * @var \DateTime|null $maxDeliveryDate public property
     */
    public $maxDeliveryDate;

    /**
     * Prazo estimado de entrega
     * @maps estimated_delivery_date
     * @factory \MundiAPILib\Utils\DateTimeHelper::fromRfc3339DateTime
     * @var \DateTime|null $estimatedDeliveryDate public property
     */
    public $estimatedDeliveryDate;

    /**
     * Shipping Type
     * @required
     * @var string $type public property
     */
    public $type;

    /**
     * Constructor to set initial or default values of member properties
     * @param integer             $amount                Initialization value for $this->amount
     * @param string              $description           Initialization value for $this->description
     * @param string              $recipientName         Initialization value for $this->recipientName
     * @param string              $recipientPhone        Initialization value for $this->recipientPhone
     * @param GetAddressResponse  $address               Initialization value for $this->address
     * @param \DateTime           $maxDeliveryDate       Initialization value for $this->maxDeliveryDate
     * @param \DateTime           $estimatedDeliveryDate Initialization value for $this->estimatedDeliveryDate
     * @param string              $type                  Initialization value for $this->type
     */
    public function __construct()
    {
        if (8 == func_num_args()) {
            $this->amount                = func_get_arg(0);
            $this->description           = func_get_arg(1);
            $this->recipientName         = func_get_arg(2);
            $this->recipientPhone        = func_get_arg(3);
            $this->address               = func_get_arg(4);
            $this->maxDeliveryDate       = func_get_arg(5);
            $this->estimatedDeliveryDate = func_get_arg(6);
            $this->type                  = func_get_arg(7);
        }
    }


    /**
     * Encode this object to JSON
     */
    public function jsonSerialize()
    {
        $json = array();
        $json['amount']                  = $this->amount;
        $json['description']             = $this->description;
        $json['recipient_name']          = $this->recipientName;
        $json['recipient_phone']         = $this->recipientPhone;
        $json['address']                 = $this->address;
        $json['max_delivery_date']       = isset($this->maxDeliveryDate) ?
            DateTimeHelper::toRfc3339DateTime($this->maxDeliveryDate) : null;
        $json['estimated_delivery_date'] = isset($this->estimatedDeliveryDate) ?
            DateTimeHelper::toRfc3339DateTime($this->estimatedDeliveryDate) : null;
        $json['type']                    = $this->type;

        return $json;
    }
}
