<?php

/**
 * This file is part of Dev5 Integração ERP Bling API V3 for OpenCart
 *
 * @author    Dev5™ <developer@dev5.com.br>
 * @copyright Dev5™ 2025. Todos os direitos reservados.
 * @license   Distribuição/reprodução não autorizada estará sujeita às penas das leis 9609/98 e 9610/98
 * @link      https://dev5.com.br/integracao-erp-bling-api-v3
 * @version   4.0.6
 */

namespace Dev5\Library\Bling;

/** @Dev5\Orm\Entity(['name' => DB_PREFIX . 'd5bling3_ei', 'auto_migrate' => false]) */
final class EIEntity extends BaseEntity
{
    const NONE = 0; // phpcs:ignore
    const PENDING = 1; // phpcs:ignore
    const SUCCESS = 2; // phpcs:ignore
    const QUEUE = 3; // phpcs:ignore
    const FAIL = 4; // phpcs:ignore

    /**
     * @var string
     * @Dev5\Orm\Field(['type' => 'varchar', 'primary' => true])
     */
    public $id;

    /**
     * @var string
     * @Dev5\Orm\Field(['type' => 'text'])
     */
    public $label;

    /**
     * @var int
     * @Dev5\Orm\Field(['type' => 'tinyint', 'index' => true, 'default' => 1])
     */
    public $status;
}
