<?php

/**
 * This file is part of Dev5 Integração ERP Bling API V3 for OpenCart
 *
 * @author    Dev5™ <developer@dev5.com.br>
 * @copyright Dev5™ 2025. Todos os direitos reservados.
 * @license   Distribuição/reprodução não autorizada estará sujeita às penas das leis 9609/98 e 9610/98
 * @link      https://dev5.com.br/integracao-erp-bling-api-v3
 * @version   4.0.6
 */

namespace Dev5\Library\Bling;

/** @Dev5\Orm\Entity(['name' => DB_PREFIX . 'd5bling3_queue', 'auto_migrate' => false]) */
final class QueueEntity extends BaseEntity
{
    const PENDING = 0; // phpcs:ignore
    const PROCESSING = 1; // phpcs:ignore
    const SUCCESS = 2; // phpcs:ignore
    const FAIL = 3; // phpcs:ignore

    /**
     * @var string
     * @Dev5\Orm\Field(['type' => 'varchar', 'primary' => true])
     */
    public $key;

    /**
     * @var int
     * @Dev5\Orm\Field(['type' => 'tinyint', 'index' => true, 'default' => 0])
     */
    public $status;

    /**
     * @var array|null
     * @Dev5\Orm\Field(['type' => 'json', 'nullable' => true])
     */
    public $payload;

    /**
     * @var \DateTime
     * @Dev5\Orm\Field([
     *     'type' => 'datetime',
     *     'length' => 3,
     *     'default' => static function() { return 'now(3)'; },
     *     'on_update' => static function() { return 'now(3)'; }
     * ])
     */
    public $timestamp;

    /**
     * @param string $key
     * @param array|null $payload
     * @param int $status
     * @param self|null $entity
     * @return bool
     */
    public static function publish($key, $payload = null, $status = self::PENDING, &$entity = null)
    {
        $entity = self::fromArray([
            'key' => $key,
            'status' => $status,
            'payload' => $payload
        ]);

        return !!$entity->save(['returning' => false]);
    }

    /**
     * @return self|null
     */
    public static function consume()
    {
        $item = self::findOne(
            ['status' => self::PENDING],
            ['order_by' => ['timestamp' => 'ASC']]
        );

        if ($item) {
            $item->status = self::PROCESSING;
            $item->save(['returning' => false]);
        }

        return $item;
    }
}
