<?php

/**
 * Box packing (3D bin packing, knapsack problem).
 *
 * @author Doug Wright
 */
namespace D5WEXT\Packing\DVDoug\BoxPacker;

use RuntimeException;

/**
 * Class NoBoxesAvailableException
 * Exception used when an item cannot be packed into any box.
 */
class NoBoxesAvailableException extends RuntimeException
{
    /** @var Item */
    public $item;

    /**
     * NoBoxesAvailableException constructor.
     * @param string $message
     * @param Item $item
     */
    public function __construct($message, Item $item)
    {
        $this->item = $item;
        parent::__construct($message);
    }

    /**
     * @return Item
     */
    public function getItem()
    {
        return $this->item;
    }
}
