<?php
if (!function_exists('hasFunc')) {
    /**
     * Dev5 Verifica se função existe
     * @param string $f function name
     * @return bool
     */
    function hasFunc($f) {
        return function_exists($f);
    }
}

if (!hasFunc('hasDir')) {
    /**
     * Dev5 Verifica se diretório existe
     * @param string $d dirname
     * @return bool
     */
    function hasDir($d) {
        return is_dir($d);
    }
}
if (!hasFunc('crtDir')) {
    /**
     * Dev5 Cria diretório se não existe
     * @param string $d dirname
     * @param int $m mode
     * @param bool $r recursive
     * @return bool
     */
    function crtDir($d,$m=0755,$r=true) {
        return !hasDir($d) ? mkdir($d,$m,$r) : true;
    }
}
if (!hasFunc('delDir')) {
    /**
     * Dev5 Remove diretório se existe
     * @param string $d filename
     * @return bool
     */
    function delDir($d) {
        if (!hasDir($d) && hasFile($d))
            return delFile($d);

        if ($d[strlen($d) - 1] != '/') $d .= '/';
        $l = glob($d . '*',GLOB_MARK);
        foreach ($l as $i) {
            if (is_dir($i)) delDir($i);
            if (is_file($i)) delFile($i);
        }
        return rmdir($d);
    }
}
if (!hasFunc('lstDir')) {
    /**
     * Dev5 Lista todos os arquivos se diretório se existe
     * @param string $d filename
     * @return array
     */
    function lstDir($d) {
        $r = [];
        if (is_dir($d))
            foreach (glob($d . '{,.}*[!.]', GLOB_BRACE) as $i)
                if (is_dir($i)) {
                    $r[] = $i;
                    $r = array_merge($r,lstDir($i . '/'));
                } else
                    $r[] = $i;
        return $r;
    }
}

if (!hasFunc('hasFile')) {
    /**
     * Dev5 Verifica se arquivo existe
     * @param string $f filename
     * @return bool
     */
    function hasFile($f) {
        return file_exists($f);
    }
}
if (!hasFunc('getFile')) {
    /**
     * Dev5 Verifica se arquivo existe
     * @param string $f filename
     * @param bool $i use_include_path
     * @param resource $c context
     * @param int $o offset
     * @return string|false
     */
    function getFile($f,$i=false,$c=null,$o=0) {
        return @file_get_contents($f,$i,$c,$o);
    }
}
if (!hasFunc('putFile')) {
    /**
     * Dev5 Verifica se arquivo existe
     * @param string $f filename
     * @param mixed $d data
     * @param int $b flag
     * @param resource $c context
     * @return int|false
     */
    function putFile($f,$d,$b=0,$c=null) {
        return @file_put_contents($f,$d,$b,$c);
    }
}
if (!hasFunc('delFile')) {
    /**
     * Dev5 Remove arquivo se existe
     * @param string $f filename
     * @return bool
     */
    function delFile($f) {
        return @unlink($f);
    }
}

if (!hasFunc('getFileJson')) {
    /**
     * Dev5 Retorna conteúdo se arquivo existe em JSON
     * @param string $f filename
     * @param bool $a $assoc
     * @return string|false
     */
    function getFileJson($f,$a=true) {
        return @json_decode(getFile($f),$a);
    }
}
if (!hasFunc('putFileJson')) {
    /**
     * Dev5 Insere conteúdo em arquivo JSON
     * @param string $f filename
     * @param array|object $d data
     * @return int|false
     */
    function putFileJson($f,$d) {
        return putFile($f,json_encode($d,JSON_UNESCAPED_UNICODE));
    }
}

if (!hasFunc('hasClass')) {
    /**
     * Dev5 Verifica se classe existe
     * @param string $c classname
     * @return bool
     */
    function hasClass($c) {
        return class_exists($c);
    }
}
if (!hasFunc('crtClass')) {
    /**
     * Dev5 Cria classe se não existe
     * @param string $c classname
     * @param mixed $e extends
     * @return bool
     */
    function crtClass($c, $e) {
        if (!hasClass($c) && hasClass($e)) {
            eval('class ' . $c . ' extends ' . $e . ' {}');
            return true;
        }
        return false;
    }
}

if (!hasFunc('ocVer')) {
    /**
     * Dev5 Compara versão informada com versão do OpenCart
     * @param string $v version2
     * @param string $o operator
     * @return bool|int
     */
    function ocVer($v,$o) {
        return version_compare(VERSION,$v,$o);
    }
}
if (!hasFunc('ocApp')) {
    /**
     * Dev5 Verifica modo do OpenCart
     * @param string $b appmode
     * @return bool
     */
    function ocApp($b) {
        if (defined('D5WS2_APPMODE'))
            return D5WS2_APPMODE === strtoupper($b);

        if (defined('D5WS1_APPMODE'))
            return D5WS1_APPMODE === strtoupper($b);

        return false;
    }
}

if (!hasFunc('pr')) {
    function pr() {
        if (func_num_args() > 0) {
            @header('Content-type: text/plain');
            exit(print_r(func_num_args() > 1 ? func_get_args() : func_get_arg(0),1));
        }
    }
}
if (!hasFunc('pre')) {
    function pre() {
        if (func_num_args() > 0)
            echo('<pre>' . print_r(func_num_args() > 1 ? func_get_args() : func_get_arg(0), 1) . '</pre>');
    }
}
if (!hasFunc('er')) {
    function er($v,$b = '') {
        $d = (defined('D5WS2_DEBUG') && D5WS2_DEBUG) || (defined('D5WS1_DEBUG') && D5WS1_DEBUG);
        exit('<b>D5WS Error</b> ' . print_r($v,1) . '<br>' . PHP_EOL . ($d && $b ? print_r($b,1) . '<br>' . PHP_EOL : ''));
    }
}